/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.collections.standard;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.IntegerList;
import com.gigaspaces.internal.collections.IntegerObjectMap;
import com.gigaspaces.internal.collections.IntegerSet;
import com.gigaspaces.internal.collections.LongObjectMap;
import com.gigaspaces.internal.collections.ObjectIntegerMap;
import com.gigaspaces.internal.collections.ObjectLongMap;
import com.gigaspaces.internal.collections.ObjectShortMap;
import com.gigaspaces.internal.collections.ShortList;
import com.gigaspaces.internal.collections.ShortLongMap;
import com.gigaspaces.internal.collections.ShortObjectMap;
import com.gigaspaces.internal.collections.standard.StandardIntegerList;
import com.gigaspaces.internal.collections.standard.StandardIntegerObjectMap;
import com.gigaspaces.internal.collections.standard.StandardIntegerSet;
import com.gigaspaces.internal.collections.standard.StandardLongObjectMap;
import com.gigaspaces.internal.collections.standard.StandardObjectIntegerMap;
import com.gigaspaces.internal.collections.standard.StandardObjectLongMap;
import com.gigaspaces.internal.collections.standard.StandardObjectShortMap;
import com.gigaspaces.internal.collections.standard.StandardShortList;
import com.gigaspaces.internal.collections.standard.StandardShortLongMap;
import com.gigaspaces.internal.collections.standard.StandardShortObjectMap;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class StandardCollectionsFactory
extends CollectionsFactory {
    @Override
    public <K, V> Map<K, V> createMap() {
        return new HashMap();
    }

    @Override
    public <K, V> Map<K, V> createMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    @Override
    public <K, V> Map<K, V> createMap(int initialCapacity, float loadFactor) {
        return new HashMap(initialCapacity, loadFactor);
    }

    @Override
    public <K, V> Map<K, V> createMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    @Override
    public ShortList createShortList() {
        return new StandardShortList();
    }

    @Override
    public IntegerList createIntegerList() {
        return new StandardIntegerList();
    }

    @Override
    public IntegerSet createIntegerSet() {
        return new StandardIntegerSet();
    }

    @Override
    public IntegerSet createIntegerSet(int initialCapacity) {
        return new StandardIntegerSet(initialCapacity);
    }

    @Override
    public ShortLongMap createShortLongMap() {
        return new StandardShortLongMap();
    }

    @Override
    protected ShortLongMap deserializeShortLongMap(Object map) {
        return new StandardShortLongMap((Map)map);
    }

    public ShortObjectMap createShortObjectMap() {
        return new StandardShortObjectMap();
    }

    @Override
    public <V> ShortObjectMap<V> createShortObjectMap(int initialCapacity) {
        return new StandardShortObjectMap(initialCapacity);
    }

    @Override
    public <K> ObjectShortMap<K> createObjectShortMap() {
        return new StandardObjectShortMap();
    }

    @Override
    public <V> LongObjectMap<V> createLongObjectMap() {
        return new StandardLongObjectMap();
    }

    @Override
    public <K> ObjectLongMap<K> createObjectLongMap() {
        return new StandardObjectLongMap();
    }

    @Override
    protected <K> ObjectShortMap<K> deserializeObjectShortMap(Object map) {
        return new StandardObjectShortMap((Map)map);
    }

    @Override
    public <V> IntegerObjectMap<V> createIntegerObjectMap() {
        return new StandardIntegerObjectMap();
    }

    @Override
    public <K> ObjectIntegerMap<K> createObjectIntegerMap() {
        return new StandardObjectIntegerMap();
    }
}

