/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.collections.standard;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.LongObjectIterator;
import com.gigaspaces.internal.collections.LongObjectMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@InternalApi
public class StandardLongObjectMap<V>
implements LongObjectMap<V> {
    private final HashMap<Long, V> map = new HashMap();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public V get(long key) {
        return this.map.get(key);
    }

    @Override
    public void put(long key, V value) {
        this.map.put(key, value);
    }

    @Override
    public V remove(long key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V[] getValues(V[] array) {
        int counter = 0;
        for (V value : this.map.values()) {
            array[counter++] = value;
        }
        return array;
    }

    @Override
    public LongObjectIterator<V> iterator() {
        return new StandardLongObjectIterator();
    }

    private class StandardLongObjectIterator
    implements LongObjectIterator<V> {
        private final Iterator<Map.Entry<Long, V>> iterator;
        private Map.Entry<Long, V> entry;

        private StandardLongObjectIterator() {
            this.iterator = StandardLongObjectMap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public void advance() {
            this.entry = this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public long key() {
            return this.entry.getKey();
        }

        @Override
        public V value() {
            return this.entry.getValue();
        }
    }
}

