/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.collections.standard;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.ShortLongIterator;
import com.gigaspaces.internal.collections.ShortLongMap;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@InternalApi
public class StandardShortLongMap
implements ShortLongMap {
    private final Map<Short, Long> map;

    public StandardShortLongMap() {
        this.map = new HashMap<Short, Long>();
    }

    public StandardShortLongMap(Map<Short, Long> map) {
        this.map = map;
    }

    @Override
    public boolean containsKey(short key) {
        return this.map.containsKey(key);
    }

    @Override
    public long get(short key) {
        return this.map.get(key);
    }

    @Override
    public long put(short key, long value) {
        return this.map.put(key, value);
    }

    @Override
    public void serialize(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this.map);
    }

    @Override
    public ShortLongIterator iterator() {
        return new StandardShortLongIterator();
    }

    private class StandardShortLongIterator
    implements ShortLongIterator {
        private final Iterator<Map.Entry<Short, Long>> iterator;
        private Map.Entry<Short, Long> entry;

        private StandardShortLongIterator() {
            this.iterator = StandardShortLongMap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public void advance() {
            this.entry = this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public short key() {
            return this.entry.getKey();
        }

        @Override
        public long value() {
            return this.entry.getValue();
        }
    }
}

