/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.collections.standard;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.ShortObjectIterator;
import com.gigaspaces.internal.collections.ShortObjectMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@InternalApi
public class StandardShortObjectMap<V>
implements ShortObjectMap<V> {
    private final HashMap<Short, V> map;

    public StandardShortObjectMap() {
        this.map = new HashMap();
    }

    public StandardShortObjectMap(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsKey(short key) {
        return this.map.containsKey(key);
    }

    @Override
    public V get(short key) {
        return this.map.get(key);
    }

    @Override
    public V put(short key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public short[] keys() {
        short[] keys = new short[this.map.size()];
        int counter = 0;
        for (Short key : this.map.keySet()) {
            keys[counter++] = key;
        }
        return keys;
    }

    @Override
    public ShortObjectIterator<V> iterator() {
        return new StandardShortObjectIterator();
    }

    private class StandardShortObjectIterator
    implements ShortObjectIterator<V> {
        private final Iterator<Map.Entry<Short, V>> iterator;
        private Map.Entry<Short, V> entry;

        private StandardShortObjectIterator() {
            this.iterator = StandardShortObjectMap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public void advance() {
            this.entry = this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public short key() {
            return this.entry.getKey();
        }

        @Override
        public V value() {
            return this.entry.getValue();
        }
    }
}

