/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.collections.trove;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.IntegerList;
import com.gigaspaces.internal.collections.IntegerObjectMap;
import com.gigaspaces.internal.collections.IntegerSet;
import com.gigaspaces.internal.collections.LongObjectMap;
import com.gigaspaces.internal.collections.MapProcedure;
import com.gigaspaces.internal.collections.ObjectIntegerMap;
import com.gigaspaces.internal.collections.ObjectLongMap;
import com.gigaspaces.internal.collections.ObjectShortMap;
import com.gigaspaces.internal.collections.ShortList;
import com.gigaspaces.internal.collections.ShortLongMap;
import com.gigaspaces.internal.collections.ShortObjectMap;
import com.gigaspaces.internal.collections.trove.TroveIntegerList;
import com.gigaspaces.internal.collections.trove.TroveIntegerObjectMap;
import com.gigaspaces.internal.collections.trove.TroveIntegerSet;
import com.gigaspaces.internal.collections.trove.TroveLongObjectMap;
import com.gigaspaces.internal.collections.trove.TroveObjectIntegerMap;
import com.gigaspaces.internal.collections.trove.TroveObjectLongMap;
import com.gigaspaces.internal.collections.trove.TroveObjectShortMap;
import com.gigaspaces.internal.collections.trove.TroveShortList;
import com.gigaspaces.internal.collections.trove.TroveShortLongMap;
import com.gigaspaces.internal.collections.trove.TroveShortObjectMap;
import com.gigaspaces.internal.gnu.trove.THashMap;
import com.gigaspaces.internal.gnu.trove.TObjectObjectProcedure;
import com.gigaspaces.internal.gnu.trove.TObjectShortHashMap;
import com.gigaspaces.internal.gnu.trove.TShortLongHashMap;
import java.util.Map;

@InternalApi
public class TroveCollectionsFactory
extends CollectionsFactory {
    @Override
    public <K, V> Map<K, V> createMap() {
        return new THashMap();
    }

    @Override
    public <K, V> Map<K, V> createMap(int initialCapacity) {
        return new THashMap(initialCapacity);
    }

    @Override
    public <K, V> Map<K, V> createMap(int initialCapacity, float loadFactor) {
        return new THashMap(initialCapacity, loadFactor);
    }

    @Override
    public <K, V> Map<K, V> createMap(Map<K, V> map) {
        return new THashMap(map);
    }

    @Override
    public <K, V> boolean forEachEntry(Map<K, V> map, final MapProcedure<K, V> procedure) {
        if (map instanceof THashMap) {
            return ((THashMap)map).forEachEntry(new TObjectObjectProcedure<K, V>(){

                public boolean execute(K key, V value) {
                    return procedure.execute(key, value);
                }
            });
        }
        return super.forEachEntry(map, procedure);
    }

    @Override
    public ShortList createShortList() {
        return new TroveShortList();
    }

    @Override
    public IntegerList createIntegerList() {
        return new TroveIntegerList();
    }

    @Override
    public IntegerSet createIntegerSet() {
        return new TroveIntegerSet();
    }

    @Override
    public IntegerSet createIntegerSet(int initialCapacity) {
        return new TroveIntegerSet(initialCapacity);
    }

    @Override
    public ShortLongMap createShortLongMap() {
        return new TroveShortLongMap();
    }

    @Override
    protected ShortLongMap deserializeShortLongMap(Object map) {
        return new TroveShortLongMap((TShortLongHashMap)map);
    }

    public ShortObjectMap createShortObjectMap() {
        return new TroveShortObjectMap();
    }

    @Override
    public <V> ShortObjectMap<V> createShortObjectMap(int initialCapacity) {
        return new TroveShortObjectMap(initialCapacity);
    }

    @Override
    public <K> ObjectShortMap<K> createObjectShortMap() {
        return new TroveObjectShortMap();
    }

    @Override
    public <V> LongObjectMap<V> createLongObjectMap() {
        return new TroveLongObjectMap();
    }

    @Override
    public <K> ObjectLongMap<K> createObjectLongMap() {
        return new TroveObjectLongMap();
    }

    @Override
    protected <K> ObjectShortMap<K> deserializeObjectShortMap(Object map) {
        return new TroveObjectShortMap((TObjectShortHashMap)map);
    }

    @Override
    public <V> IntegerObjectMap<V> createIntegerObjectMap() {
        return new TroveIntegerObjectMap();
    }

    @Override
    public <K> ObjectIntegerMap<K> createObjectIntegerMap() {
        return new TroveObjectIntegerMap();
    }
}

