/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.datasource.EDSAdapterSpaceDataSource;
import com.gigaspaces.internal.datasource.EDSAdapterSynchronizationEndpoint;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.sync.SynchronizationStorageAdapter;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.sadapter.IStorageAdapter;
import com.j_spaces.kernel.ClassLoaderHelper;
import com.j_spaces.sadapter.datasource.DataStorage;

@InternalApi
public class EDSAdapter {
    public static IStorageAdapter create(SpaceEngine spaceEngine, JSpaceAttributes spaceAttributes) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object dataSource = spaceAttributes.getCustomProperties().get("external-data-source.data-source");
        if (dataSource == null) {
            String dataSourceClassName = spaceAttributes.getProperty("space-config.external-data-source.data-source-class", "org.openspaces.persistency.hibernate.DefaultHibernateExternalDataSource");
            dataSource = ClassLoaderHelper.loadClass(dataSourceClassName).newInstance();
        }
        DataStorage<Object> dataStorage = new DataStorage<Object>(dataSource);
        boolean supportsInheritance = Boolean.parseBoolean(spaceAttributes.getProperty("space-config.external-data-source.supports-inheritance", "true"));
        String usageString = spaceAttributes.getProperty("space-config.external-data-source.usage", "read-write");
        boolean readonly = false;
        if (usageString.equalsIgnoreCase("read-only")) {
            readonly = true;
        } else if (usageString.equalsIgnoreCase("read-write")) {
            readonly = false;
        } else {
            throw new IllegalArgumentException("usage space property only accepts the following values [read-only, read-write] but its value was set to: " + usageString);
        }
        EDSAdapterSynchronizationEndpoint synchronizationEndpointInterceptor = !readonly && (dataStorage.isDataPersister() || dataStorage.isBulkDataPersister()) ? new EDSAdapterSynchronizationEndpoint(spaceEngine, dataStorage) : null;
        return new SynchronizationStorageAdapter(spaceEngine, new EDSAdapterSpaceDataSource(dataStorage, supportsInheritance), synchronizationEndpointInterceptor);
    }
}

