/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.datasource.DataSourceSQLQuery;
import com.gigaspaces.datasource.SpaceDataSource;
import com.gigaspaces.datasource.SpaceDataSourceException;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.sadapter.datasource.DataStorage;
import java.util.Properties;

@InternalApi
public class EDSAdapterSpaceDataSource
extends SpaceDataSource {
    private final DataStorage<Object> _storage;
    private final boolean _supportsInheritance;

    public EDSAdapterSpaceDataSource(DataStorage<Object> dataStorage, boolean supportsInheritance) {
        this._storage = dataStorage;
        this._supportsInheritance = supportsInheritance;
    }

    @Override
    public DataIterator<Object> initialDataLoad() {
        if (this._storage.isManagedDataSource()) {
            try {
                return this._storage.initialLoad();
            }
            catch (DataSourceException e) {
                throw new SpaceDataSourceException(e);
            }
        }
        return null;
    }

    @Override
    public DataIterator<SpaceTypeDescriptor> initialMetadataLoad() {
        return null;
    }

    @Override
    public DataIterator<Object> getDataIterator(DataSourceQuery query) {
        try {
            if (this._storage.isSQLDataProvider()) {
                DataSourceSQLQuery sqlQueryInfo = query.getAsSQLQuery();
                SQLQuery sqlQuery = new SQLQuery(query.getTypeDescriptor().getTypeName(), sqlQueryInfo.getQuery(), sqlQueryInfo.getQueryParameters());
                return this._storage.iterator(sqlQuery);
            }
            if (this._storage.isDataProvider() && query.supportsTemplateAsObject()) {
                return this._storage.iterator(query.getTemplateAsObject());
            }
        }
        catch (DataSourceException e) {
            throw new SpaceDataSourceException(e);
        }
        return null;
    }

    @Override
    public boolean supportsInheritance() {
        return this._supportsInheritance;
    }

    public void initialize(Properties dataProperties) throws DataSourceException {
        if (this._storage.isManagedDataSource()) {
            this._storage.init(dataProperties);
        }
    }

    public DataStorage<Object> getDataStorage() {
        return this._storage;
    }
}

