/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.BulkItem;
import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.sync.OperationsBatchData;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.gigaspaces.sync.SpaceSynchronizationEndpointException;
import com.gigaspaces.sync.TransactionData;
import com.j_spaces.sadapter.datasource.BulkDataPersisterContext;
import com.j_spaces.sadapter.datasource.DataStorage;
import java.util.ArrayList;
import java.util.List;
import net.jini.core.transaction.server.TransactionParticipantDataImpl;

@InternalApi
public class EDSAdapterSynchronizationEndpoint
extends SpaceSynchronizationEndpoint {
    private final DataStorage<Object> _dataStorage;
    private final SpaceEngine _spaceEngine;

    public EDSAdapterSynchronizationEndpoint(SpaceEngine spaceEngine, DataStorage<Object> dataStorage) {
        this._spaceEngine = spaceEngine;
        this._dataStorage = dataStorage;
    }

    @Override
    public void onTransactionSynchronization(TransactionData transactionData) {
        block7: {
            try {
                if (this._dataStorage.isBulkDataPersister()) {
                    try {
                        BulkDataPersisterContext.setContext(new BulkDataPersisterContext((TransactionParticipantDataImpl)transactionData.getTransactionParticipantMetaData(), this._spaceEngine.getFullSpaceName()));
                        this._dataStorage.executeBulk(this.convertToBulkItemsList(transactionData.getTransactionParticipantDataItems()));
                        break block7;
                    }
                    finally {
                        BulkDataPersisterContext.resetContext();
                    }
                }
                if (this._dataStorage.isDataPersister()) {
                    this.executeOperationsOneByOne(transactionData.getTransactionParticipantDataItems());
                }
            }
            catch (DataSourceException e) {
                throw new SpaceSynchronizationEndpointException(e);
            }
        }
    }

    private void executeOperationsOneByOne(DataSyncOperation[] operations) throws DataSourceException {
        block6: for (DataSyncOperation operation : operations) {
            BulkItem bulkItem = (BulkItem)operation;
            switch (operation.getDataSyncOperationType()) {
                case WRITE: {
                    this._dataStorage.write(bulkItem.getItem());
                    continue block6;
                }
                case UPDATE: {
                    this._dataStorage.update(bulkItem.getItem());
                    continue block6;
                }
                case PARTIAL_UPDATE: {
                    continue block6;
                }
                case REMOVE: {
                    this._dataStorage.remove(bulkItem.getItem());
                    continue block6;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private List<BulkItem> convertToBulkItemsList(DataSyncOperation[] operations) {
        ArrayList<BulkItem> bulkItems = new ArrayList<BulkItem>(operations.length);
        for (DataSyncOperation operation : operations) {
            bulkItems.add((BulkItem)operation);
        }
        return bulkItems;
    }

    @Override
    public void onOperationsBatchSynchronization(OperationsBatchData batchData) {
        try {
            if (this._dataStorage.isBulkDataPersister()) {
                this._dataStorage.executeBulk(this.convertToBulkItemsList(batchData.getBatchDataItems()));
            } else if (this._dataStorage.isDataPersister()) {
                this.executeOperationsOneByOne(batchData.getBatchDataItems());
            }
        }
        catch (DataSourceException e) {
            throw new SpaceSynchronizationEndpointException(e);
        }
    }

    public DataStorage<Object> getDataStorage() {
        return this._dataStorage;
    }
}

