/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.document;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.DocumentObjectConverter;
import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.io.MarshObject;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.SpaceStringProperty;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.ClassUtils;
import com.gigaspaces.internal.utils.ReflectionUtils;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import java.util.Arrays;
import java.util.Map;

@InternalApi
public class DocumentObjectConverterInternal
extends DocumentObjectConverter {
    private static final DocumentObjectConverterInternal _instance = new DocumentObjectConverterInternal();

    public static DocumentObjectConverterInternal instance() {
        return _instance;
    }

    protected DocumentObjectConverterInternal() {
    }

    @Override
    public Object toDocumentIfNeeded(Object object, SpaceDocumentSupport documentSupport) {
        return super.toDocumentIfNeeded(object, documentSupport);
    }

    @Override
    public Object fromDocumentIfNeeded(Object object, SpaceDocumentSupport documentSupport, Class<?> expectedType) {
        return super.fromDocumentIfNeeded(object, documentSupport, expectedType);
    }

    public void convertNonPrimitivePropertiesToStrings(IEntryPacket entryPacket) {
        Map<String, Object> dynamicProperties;
        Map<String, Object> convertedDynamicProperties;
        Object[] fixedProperties = entryPacket.getFieldValues();
        Object[] convertedFixedProperties = this.convertNonPrimitiveFixedPropertiesToStrings(fixedProperties, entryPacket.getTypeDescriptor());
        if (convertedFixedProperties != fixedProperties) {
            entryPacket.setFieldsValues(convertedFixedProperties);
        }
        if ((convertedDynamicProperties = this.convertNonPrimitiveDynamicPropertiesToStrings(dynamicProperties = entryPacket.getDynamicProperties())) != dynamicProperties) {
            entryPacket.setDynamicProperties(convertedDynamicProperties);
        }
    }

    public void convertNonPrimitivePropertiesToDocuments(IEntryPacket entryPacket) {
        Map<String, Object> dynamicProperties;
        Map<String, Object> convertedDynamicProperties;
        Object[] values = entryPacket.getFieldValues();
        Object[] convertedValues = this.convertNonPrimitiveFixedPropertiesToDocuments(values, entryPacket.getTypeDescriptor());
        if (convertedValues != values) {
            entryPacket.setFieldsValues(convertedValues);
        }
        if ((convertedDynamicProperties = this.convertNonPrimitiveDynamicPropertiesToDocuments(dynamicProperties = entryPacket.getDynamicProperties())) != dynamicProperties) {
            entryPacket.setDynamicProperties(convertedDynamicProperties);
        }
    }

    private Object[] convertNonPrimitiveFixedPropertiesToStrings(Object[] values, ITypeDesc typeDesc) {
        Object[] convertedValues = null;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                SpaceStringProperty convertedValue;
                if (values[i] == null || typeDesc.getFixedProperty(i).isCommonJavaType() || (convertedValue = DocumentObjectConverterInternal.toSpaceStringProperty(values[i])) == values[i]) continue;
                if (convertedValues == null) {
                    convertedValues = (Object[])values.clone();
                }
                convertedValues[i] = convertedValue;
            }
        }
        return convertedValues != null ? convertedValues : values;
    }

    public Object[] convertNonPrimitiveFixedPropertiesToDocuments(Object[] values, ITypeDesc typeDesc) {
        Object[] convertedValues = null;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                Object convertedValue;
                if (values[i] == null || typeDesc.getFixedProperty(i).isCommonJavaType() || (convertedValue = this.toDocumentIfNeeded(values[i])) == values[i]) continue;
                if (convertedValues == null) {
                    convertedValues = (Object[])values.clone();
                }
                convertedValues[i] = convertedValue;
            }
        }
        return convertedValues != null ? convertedValues : values;
    }

    private Map<String, Object> convertNonPrimitiveDynamicPropertiesToStrings(Map<String, Object> values) {
        DocumentProperties convertedValues = null;
        if (values != null && !values.isEmpty()) {
            for (Map.Entry<String, Object> dynamicProperty : values.entrySet()) {
                SpaceStringProperty convertedValue;
                Object value = dynamicProperty.getValue();
                if (value == null || ReflectionUtils.isCommonJavaType(value.getClass()) || (convertedValue = DocumentObjectConverterInternal.toSpaceStringProperty(value)) == value) continue;
                if (convertedValues == null) {
                    convertedValues = new DocumentProperties(values);
                }
                convertedValues.put(dynamicProperty.getKey(), convertedValue);
            }
        }
        return convertedValues != null ? convertedValues : values;
    }

    public Map<String, Object> convertNonPrimitiveDynamicPropertiesToDocuments(Map<String, Object> values) {
        DocumentProperties convertedValues = null;
        if (values != null && !values.isEmpty()) {
            for (Map.Entry<String, Object> dynamicProperty : values.entrySet()) {
                Object convertedValue;
                Object value = dynamicProperty.getValue();
                if (value == null || ReflectionUtils.isCommonJavaType(value.getClass()) || (convertedValue = this.toDocumentIfNeeded(value)) == value) continue;
                if (convertedValues == null) {
                    convertedValues = new DocumentProperties(values);
                }
                convertedValues.put(dynamicProperty.getKey(), convertedValue);
            }
        }
        return convertedValues != null ? convertedValues : values;
    }

    private Object toDocumentIfNeeded(Object value) {
        Class<?> type = value.getClass();
        if (type.isEnum()) {
            return new SpaceDocument(type.getName()).setProperty("value", value.toString());
        }
        if (MarshObject.class.isAssignableFrom(type)) {
            return value;
        }
        return this.toDocumentIfNeeded(value, SpaceDocumentSupport.DEFAULT);
    }

    private static SpaceStringProperty toSpaceStringProperty(Object propertyValue) {
        Class<?> propertyClass = propertyValue.getClass();
        String valueStr = null;
        valueStr = propertyClass.isArray() ? (propertyClass == byte[].class ? Arrays.toString((byte[])propertyValue) : (propertyClass == short[].class ? Arrays.toString((short[])propertyValue) : (propertyClass == int[].class ? Arrays.toString((int[])propertyValue) : (propertyClass == long[].class ? Arrays.toString((long[])propertyValue) : (propertyClass == char[].class ? Arrays.toString((char[])propertyValue) : (propertyClass == float[].class ? Arrays.toString((float[])propertyValue) : (propertyClass == double[].class ? Arrays.toString((double[])propertyValue) : (propertyClass == boolean[].class ? Arrays.toString((boolean[])propertyValue) : Arrays.deepToString((Object[])propertyValue))))))))) : propertyValue.toString();
        return new SpaceStringProperty(ClassUtils.getTypeDisplayName(propertyClass.getName()), valueStr);
    }
}

