/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.dump;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.dump.InternalDumpDownloadListener;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import com.gigaspaces.internal.dump.InternalDumpProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

@InternalApi
public class InternalDumpResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String fullPath;
    private final String name;
    private final FileInfo[] files;
    private final InternalDumpProcessorFailedException[] failedProcessors;

    public InternalDumpResult(String name, String fullPath, FileInfo[] files, InternalDumpProcessorFailedException[] failedProcessors) {
        this.name = name;
        this.fullPath = fullPath;
        this.files = files;
        this.failedProcessors = failedProcessors;
    }

    public String getName() {
        return this.name;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public FileInfo[] getFiles() {
        return this.files;
    }

    public InternalDumpProcessorFailedException[] getFailedProcessors() {
        return this.failedProcessors;
    }

    public long downloadSize() {
        long downloadSize = 0L;
        for (FileInfo fileInfo : this.files) {
            downloadSize += fileInfo.size;
        }
        return downloadSize;
    }

    public void download(InternalDumpProvider dumpProvider, File target, InternalDumpDownloadListener listener) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(target));
        this.download(dumpProvider, zos, listener);
        zos.close();
    }

    public void download(InternalDumpProvider dumpProvider, File targetDirectory, String fileName, InternalDumpDownloadListener listener) throws Exception {
        if (!fileName.endsWith(".zip")) {
            fileName = fileName + ".zip";
        }
        File zipFile = new File(targetDirectory, fileName);
        this.download(dumpProvider, zipFile, listener);
    }

    public void download(InternalDumpProvider dumpProvider, ZipOutputStream zos, InternalDumpDownloadListener listener) throws IOException {
        for (FileInfo fileInfo : this.files) {
            this.downloadFile(dumpProvider, fileInfo, zos, listener);
        }
    }

    public void downloadFile(InternalDumpProvider dumpProvider, FileInfo fileInfo, ZipOutputStream zos, InternalDumpDownloadListener listener) throws IOException {
        byte[] result;
        try {
            zos.putNextEntry(new ZipEntry(this.name + "/" + fileInfo.getName()));
        }
        catch (ZipException e) {
            if (e.getMessage() != null && e.getMessage().contains("duplicate entry")) {
                return;
            }
            throw e;
        }
        long counter = 0L;
        int size = 0x100000;
        while ((result = dumpProvider.dumpBytes(this.name + "/" + fileInfo.getName(), counter, size)).length != 0) {
            if (listener != null) {
                listener.onDownload(result.length, this.name, fileInfo.getName());
            }
            zos.write(result);
            if (result.length < size) break;
            counter += (long)result.length;
        }
    }

    public static class FileInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private long size;

        public FileInfo(String name, long size) {
            this.name = name;
            this.size = size;
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }
    }
}

