/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.events.durable;

import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseExpiredHandler;
import com.gigaspaces.internal.cluster.node.impl.notification.NotificationReplicationChannelDataFilter;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import net.jini.core.event.RemoteEventListener;

public abstract class AbstractReplicationNotificationInEntryHandler
implements IReplicationInEntryHandler,
IReplicationInEntryLeaseExpiredHandler {
    protected final NotifyInfo _notifyInfo;
    protected final NotifyActionType _notifyType;
    protected final RemoteEventListener _listener;
    protected final IDirectSpaceProxy _remoteSpace;
    protected final AtomicLong _sequenceNumber;
    protected final long _eventID;
    private final QueryResultTypeInternal _queryResultType;

    protected AbstractReplicationNotificationInEntryHandler(NotifyInfo notifyInfo, IDirectSpaceProxy remoteSpace, long eventID, ITemplatePacket templatePacket) {
        this._notifyInfo = notifyInfo;
        this._remoteSpace = remoteSpace;
        this._eventID = eventID;
        this._queryResultType = templatePacket.getQueryResultType();
        this._notifyType = NotifyActionType.fromModifier(this._notifyInfo.getNotifyType());
        this._listener = notifyInfo.getListener();
        this._sequenceNumber = new AtomicLong(0L);
    }

    protected static void consumeBatchContentIfNotInTransaction(IReplicationInContext context, boolean inTransaction) {
        if (!inTransaction) {
            IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
            batchContext.currentConsumed();
        }
    }

    public void handleEntryLeaseExpiredByUID(IReplicationInContext context, boolean inTransaction, String className, String uid, boolean isTransient, OperationID operationID) {
        throw new UnsupportedOperationException();
    }

    public void handleEntryLeaseExpired(IReplicationInContext context, boolean inTransaction, IEntryPacket entryPacket) {
        this.handleEntry(context, inTransaction, entryPacket, null, NotifyActionType.NOTIFY_LEASE_EXPIRATION);
    }

    public void handleUpdateEntry(IReplicationInContext context, boolean inTransaction, IEntryPacket entryPacket, IEntryPacket oldEntryPacket, boolean partialUpdate, boolean overrideVersion, short flags) {
        NotifyActionType actionType = NotifyActionType.NOTIFY_UPDATE;
        if (NotificationReplicationChannelDataFilter.DurableNotificationConversionFlags.isUpdateToUnmatched(flags)) {
            actionType = NotifyActionType.NOTIFY_UNMATCHED;
        } else if (NotificationReplicationChannelDataFilter.DurableNotificationConversionFlags.isUpdateToMatchedUpdate(flags)) {
            actionType = NotifyActionType.NOTIFY_MATCHED_UPDATE;
        } else if (NotificationReplicationChannelDataFilter.DurableNotificationConversionFlags.isUpdateToRematchedUpdate(flags)) {
            actionType = NotifyActionType.NOTIFY_REMATCHED_UPDATE;
        }
        this.handleEntry(context, inTransaction, entryPacket, oldEntryPacket, actionType);
    }

    public void handleRemoveEntry(IReplicationInContext context, boolean inTransaction, IEntryPacket entryPacket) {
        this.handleEntry(context, inTransaction, entryPacket, null, NotifyActionType.NOTIFY_TAKE);
    }

    public void handleRemoveEntryByUID(IReplicationInContext context, boolean inTransaction, String uid, boolean isTransient, OperationID operationID) {
        throw new UnsupportedOperationException();
    }

    public void handleWriteEntry(IReplicationInContext context, boolean inTransaction, IEntryPacket entryPacket) {
        this.handleEntry(context, inTransaction, entryPacket, null, NotifyActionType.NOTIFY_WRITE);
    }

    private void handleEntry(IReplicationInContext context, boolean inTransaction, IEntryPacket entryPacket, IEntryPacket oldEntryPacket, NotifyActionType notifyActionType) {
        this._remoteSpace.getTypeManager().loadTypeDescToPacket(entryPacket);
        EntryArrivedRemoteEvent entryArrived = this.createEntryArrivedRemoteEvent(entryPacket, oldEntryPacket, notifyActionType);
        this.handleEntryImpl(entryArrived, context, inTransaction);
    }

    protected abstract void handleEntryImpl(EntryArrivedRemoteEvent var1, IReplicationInContext var2, boolean var3);

    protected EntryArrivedRemoteEvent createEntryArrivedRemoteEvent(IEntryPacket entryPacket, IEntryPacket oldEntryPacket, NotifyActionType notifyActionType) {
        if (notifyActionType.equals(NotifyActionType.NOTIFY_UNMATCHED)) {
            return new EntryArrivedRemoteEvent(this._remoteSpace, this._eventID, this._sequenceNumber.getAndIncrement(), this._notifyInfo.getHandback(), oldEntryPacket, entryPacket, notifyActionType, false, this._notifyInfo.getTemplateUID(), this._queryResultType);
        }
        return new EntryArrivedRemoteEvent(this._remoteSpace, this._eventID, this._sequenceNumber.getAndIncrement(), this._notifyInfo.getHandback(), entryPacket, oldEntryPacket, notifyActionType, false, this._notifyInfo.getTemplateUID(), this._queryResultType);
    }

    @Override
    public void inEntryLeaseExpiredByUID(IReplicationInContext context, String className, String uid, boolean isTransient, OperationID operationID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void inEntryLeaseExpired(IReplicationInContext context, IEntryPacket entryPacket) {
        this.handleEntryLeaseExpired(context, false, entryPacket);
    }

    @Override
    public void inUpdateEntry(IReplicationInContext context, IEntryPacket entryPacket, IEntryPacket oldEntryPacket, boolean partialUpdate, boolean overrideVersion, short flags) throws Exception {
        this.handleUpdateEntry(context, false, entryPacket, oldEntryPacket, partialUpdate, overrideVersion, flags);
    }

    @Override
    public void inRemoveEntry(IReplicationInContext context, IEntryPacket entryPacket) throws Exception {
        this.handleRemoveEntry(context, false, entryPacket);
    }

    @Override
    public void inRemoveEntryByUID(IReplicationInContext context, String typeName, String uid, boolean isTransient, OperationID operationID) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void inWriteEntry(IReplicationInContext context, IEntryPacket entryPacket) throws Exception {
        this.handleWriteEntry(context, false, entryPacket);
    }

    @Override
    public void inChangeEntry(IReplicationInContext context, String typeName, String uid, Object id, int version, int previousVersion, int routingHash, long timeToLive, Collection<SpaceEntryMutator> mutators, boolean isTransient, OperationID operationID) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterConsumption(IReplicationInContext context, boolean successful, long lastProcessedKey) {
    }

    @Override
    public void beforeConsume(IReplicationInContext context) {
    }
}

