/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.events.durable;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.internal.events.durable.ReplicationNotificationClientEndpoint;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.j_spaces.core.LeaseManager;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;

@InternalApi
public class DurableNotificationLease
implements Lease {
    private final Logger _logger;
    private final ReplicationNotificationClientEndpoint _clientEndpoint;
    private final IAsyncHandlerProvider _asyncProvider;
    private final Object _lock = new Object();
    private IAsyncHandler _currentTask;
    private boolean _cancelled;
    private volatile long _currentExpiration;
    private volatile long _currentLease;

    public DurableNotificationLease(ReplicationNotificationClientEndpoint replicationNotificationClientEndpoint, long lease, EventSessionConfig sessionConfig, IAsyncHandlerProvider asyncProvider) {
        this._logger = replicationNotificationClientEndpoint.getLogger();
        this._clientEndpoint = replicationNotificationClientEndpoint;
        this._asyncProvider = asyncProvider;
        this.updateLeaseAndExpiration(this.getActualLease(lease, sessionConfig));
    }

    public Logger getLogger() {
        return this._logger;
    }

    private long getActualLease(long lease, EventSessionConfig sessionConfig) {
        return sessionConfig.isAutoRenew() ? Math.max(lease, sessionConfig.getRenewExpiration()) : lease;
    }

    public void startLeaseReaperIfNecessary() {
        if (this._currentLease != Long.MAX_VALUE && this._currentLease != -1L && this._currentExpiration > 0L) {
            this.restartLeaseExpirationReaper(this._currentLease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartLeaseExpirationReaper(long duration) {
        Object object = this._lock;
        synchronized (object) {
            if (this._currentTask != null) {
                this._currentTask.stop(10L, TimeUnit.MILLISECONDS);
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Scheduling lease cancel thread, will be activated in " + duration + "ms");
            }
            this._currentTask = this._asyncProvider.start(new AsyncCallable(){

                @Override
                public IAsyncHandlerProvider.CycleResult call() throws Exception {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (DurableNotificationLease.this._logger.isLoggable(Level.FINE)) {
                                DurableNotificationLease.this._logger.log(Level.FINE, "Lease cancel thread was activated, canceling lease");
                            }
                            DurableNotificationLease.this.cancel();
                        }
                    }).start();
                    return IAsyncHandlerProvider.CycleResult.TERMINATE;
                }
            }, duration, "DurableNotifyLeaseMonitor", true);
            this.updateLeaseAndExpiration(duration);
        }
    }

    public long getExpiration() {
        return this._currentExpiration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this._lock;
        synchronized (object) {
            if (this._cancelled) {
                return;
            }
            this._cancelled = true;
            if (this._currentTask != null) {
                this._currentTask.stop(10L, TimeUnit.MILLISECONDS);
            }
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Lease cancel request, canceling lease on registration");
        }
        this._clientEndpoint.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renew(long duration) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        Object object = this._lock;
        synchronized (object) {
            if (this._cancelled) {
                throw new UnknownLeaseException("Lease is already cancelled");
            }
            if (duration < 0L) {
                return;
            }
            if (duration == Long.MAX_VALUE) {
                if (this._currentTask != null) {
                    this._currentTask.stop(10L, TimeUnit.MILLISECONDS);
                    this._currentTask = null;
                }
                this.updateLeaseAndExpiration(Long.MAX_VALUE);
                return;
            }
            this.restartLeaseExpirationReaper(duration);
        }
    }

    private void updateLeaseAndExpiration(long lease) {
        this._currentLease = lease;
        this._currentExpiration = LeaseManager.toAbsoluteTime(this._currentLease);
    }

    public void setSerialFormat(int format) {
    }

    public int getSerialFormat() {
        return 0;
    }

    public LeaseMap createLeaseMap(long duration) {
        return null;
    }

    public boolean canBatch(Lease lease) {
        return false;
    }
}

