/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.events.durable;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.IncomingReplicationOutOfSyncException;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.internal.cluster.node.IReplicationNodeStateListener;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeMode;
import com.gigaspaces.internal.cluster.node.impl.groups.BrokenReplicationTopologyException;
import com.gigaspaces.internal.events.durable.DurableNotificationLease;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterUtils;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.time.SystemTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;

@InternalApi
public class DurableNotificationReplicationNodeStateListener
implements IReplicationNodeStateListener {
    private final Logger _logger;
    private final EventSessionConfig _config;
    private final DurableNotificationLease _lease;
    private final LeaseListener _leaseListener;
    private final IAsyncHandlerProvider _asyncProvider;
    private final int _numOfPartitions;
    private final int _partitionId;
    private final Object _lock = new Object();
    private final Map<Integer, Long> _disconnectedPartitions;
    private long _disconnectTime;
    private boolean _disconnectionMonitorInProgress;
    private boolean _channelClosed;
    private IAsyncHandler _asyncHandler;

    public DurableNotificationReplicationNodeStateListener(EventSessionConfig config, DurableNotificationLease lease, IAsyncHandlerProvider asyncProvider, int numOfPartitions, int partitionId) {
        this._logger = lease.getLogger();
        this._lease = lease;
        this._config = config;
        this._asyncProvider = asyncProvider;
        this._numOfPartitions = numOfPartitions;
        this._partitionId = partitionId;
        this._leaseListener = this._config.getLeaseListener();
        this._disconnectedPartitions = this.populateDisconnectedPartitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDisconnectionMonitoring() {
        Object object = this._lock;
        synchronized (object) {
            if (this._disconnectionMonitorInProgress) {
                return;
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Starting disconnection monitoring");
            }
            this._disconnectionMonitorInProgress = true;
            this._asyncHandler = this._asyncProvider.start(new DisconnectionMonitorAsyncCallable(), 1000L, "DurableNotificationDisconnectionMonitor", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onTargetChannelOutOfSync(String groupName, String channelSourceLookupName, IncomingReplicationOutOfSyncException outOfSyncReason) {
        Object object = this._lock;
        synchronized (object) {
            if (this._channelClosed) {
                return true;
            }
        }
        this.notifyClientListenerAndCloseStateListener();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTargetChannelBacklogDropped(String groupName, String channelSourceLooString, IBacklogMemberState memberState) {
        Object object = this._lock;
        synchronized (object) {
            if (this._channelClosed) {
                return;
            }
        }
        this.notifyClientListenerAndCloseStateListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTargetChannelSourceDisconnected(String groupName, String sourceMemberName, Object sourceUniqueId) {
        Object object = this._lock;
        synchronized (object) {
            if (this._channelClosed) {
                return;
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Target channel source disconnected, member name: " + sourceMemberName);
            }
            long currTime = SystemTime.timeMillis();
            int partitionId = DurableNotificationReplicationNodeStateListener.extractPartitionId(sourceMemberName);
            this._disconnectedPartitions.put(partitionId, currTime);
            this._disconnectTime = this.updateDisconnectTime();
            if (this._config.isAutoRenew() && this._config.getLeaseListener() != null) {
                this.startDisconnectionMonitoring();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTargetChannelConnected(String groupName, String sourceMemberName, Object sourceUniqueId) {
        Object object = this._lock;
        synchronized (object) {
            if (this._channelClosed) {
                return;
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Target channel connected, member name: " + sourceMemberName);
            }
            int partitionId = DurableNotificationReplicationNodeStateListener.extractPartitionId(sourceMemberName);
            this._disconnectedPartitions.remove(partitionId);
            this._disconnectTime = this.updateDisconnectTime();
        }
    }

    @Override
    public void onReplicationNodeModeChange(ReplicationNodeMode newMode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this._lock;
        synchronized (object) {
            if (this._channelClosed) {
                return;
            }
            if (this._asyncHandler != null) {
                this._asyncHandler.stop(3L, TimeUnit.SECONDS);
            }
            this._asyncHandler = null;
            this._channelClosed = true;
        }
    }

    private Map<Integer, Long> populateDisconnectedPartitions() {
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        int startIndex = this._partitionId == -1 ? 0 : this._partitionId;
        int endIndex = this._partitionId == -1 ? this._numOfPartitions - 1 : this._partitionId;
        for (int i = startIndex; i <= endIndex; ++i) {
            long currentTime = SystemTime.timeMillis();
            result.put(i, currentTime);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientListenerAndCloseStateListener() {
        Object object = this._lock;
        synchronized (object) {
            if (this._channelClosed) {
                return;
            }
            this._channelClosed = true;
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Sending disconnection notification and closing listener");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                DurableNotificationReplicationNodeStateListener.this._lease.cancel();
            }
        }).start();
        if (this._leaseListener != null) {
            this._leaseListener.notify(new LeaseRenewalEvent(this, this._lease, this._lease.getExpiration(), null));
        }
    }

    private boolean isHealthy() {
        long disconnectTime = this._disconnectTime;
        if (this.isAllConnected()) {
            return true;
        }
        long disconnectDuration = SystemTime.timeMillis() - disconnectTime;
        return disconnectDuration < this._config.getRenewDuration();
    }

    private boolean isAllConnected() {
        return this._disconnectTime == 0L;
    }

    private long updateDisconnectTime() {
        long oldestDisconnectTime = 0L;
        for (Long disconnectTime : this._disconnectedPartitions.values()) {
            if (oldestDisconnectTime != 0L && oldestDisconnectTime <= disconnectTime) continue;
            oldestDisconnectTime = disconnectTime;
        }
        return oldestDisconnectTime;
    }

    private static int extractPartitionId(String memberName) {
        return PartitionedClusterUtils.extractPartitionIdFromSpaceName(memberName);
    }

    @Override
    public void onTargetChannelCreationValidation(String groupName, String sourceMemberName, Object sourceUniqueId) {
    }

    @Override
    public void onSourceBrokenReplicationTopology(String groupName, String channelTargetMemberName, BrokenReplicationTopologyException error) {
    }

    @Override
    public void onSourceChannelActivated(String groupName, String memberName) {
    }

    @Override
    public void onNewReplicaRequest(String groupName, String channelName, boolean isSynchronizeRequest) {
    }

    private class DisconnectionMonitorAsyncCallable
    extends AsyncCallable {
        private DisconnectionMonitorAsyncCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IAsyncHandlerProvider.CycleResult call() throws Exception {
            Object object = DurableNotificationReplicationNodeStateListener.this._lock;
            synchronized (object) {
                DurableNotificationReplicationNodeStateListener.this._disconnectTime = DurableNotificationReplicationNodeStateListener.this.updateDisconnectTime();
                if (DurableNotificationReplicationNodeStateListener.this.isAllConnected()) {
                    if (DurableNotificationReplicationNodeStateListener.this._logger.isLoggable(Level.FINER)) {
                        DurableNotificationReplicationNodeStateListener.this._logger.log(Level.FINER, "From monitor: all partitions connected, stable state restored");
                    }
                    DurableNotificationReplicationNodeStateListener.this._disconnectionMonitorInProgress = false;
                    return IAsyncHandlerProvider.CycleResult.TERMINATE;
                }
                if (DurableNotificationReplicationNodeStateListener.this.isHealthy()) {
                    if (DurableNotificationReplicationNodeStateListener.this._logger.isLoggable(Level.FINER)) {
                        DurableNotificationReplicationNodeStateListener.this._logger.log(Level.FINER, "From monitor: Not all partitions are alive yet, rechecking");
                    }
                    return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                }
                if (DurableNotificationReplicationNodeStateListener.this._logger.isLoggable(Level.FINER)) {
                    DurableNotificationReplicationNodeStateListener.this._logger.log(Level.FINER, "From monitor: Maximum disconnection time elapsed, closing registration");
                }
                DurableNotificationReplicationNodeStateListener.this.notifyClientListenerAndCloseStateListener();
                DurableNotificationReplicationNodeStateListener.this._disconnectionMonitorInProgress = false;
                return IAsyncHandlerProvider.CycleResult.TERMINATE;
            }
        }
    }
}

