/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.events.durable;

import com.gigaspaces.events.AbstractDataEventSession;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.events.IInternalEventSessionAdmin;
import com.gigaspaces.internal.events.durable.DurableNotificationLease;
import com.gigaspaces.internal.events.durable.ReplicationNotificationClientEndpoint;
import com.j_spaces.core.IJSpace;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jini.core.event.EventRegistration;
import net.jini.id.Uuid;

public final class DurableUnicastDelegatorSession
extends AbstractDataEventSession
implements IInternalEventSessionAdmin {
    private final Map<EventRegistration, ReplicationNotificationClientEndpoint> _notifications = new ConcurrentHashMap<EventRegistration, ReplicationNotificationClientEndpoint>();

    public DurableUnicastDelegatorSession(IJSpace space, EventSessionConfig config) {
        super(space, config);
    }

    @Override
    protected EventRegistration addListenerInternal(Object template, long lease, NotifyInfo info) throws RemoteException {
        GSEventRegistration eventRegistration = null;
        ReplicationNotificationClientEndpoint notification = new ReplicationNotificationClientEndpoint(this.getNotificationsSpace(), template, info, this.getSessionConfig(), lease);
        long eventID = notification.getEventID();
        String templateUID = info.getTemplateUID();
        Uuid spaceUID = notification.getSpaceUID();
        DurableNotificationLease durableLease = notification.getLease();
        eventRegistration = new GSEventRegistration(eventID, null, durableLease, 0L, templateUID, spaceUID);
        this._notifications.put(eventRegistration, notification);
        return eventRegistration;
    }

    @Override
    public void removeListener(EventRegistration registration) throws RemoteException {
        ReplicationNotificationClientEndpoint endpoint = this._notifications.remove(registration);
        if (endpoint != null) {
            endpoint.close();
        }
    }

    @Override
    public void close() throws RemoteException {
        for (ReplicationNotificationClientEndpoint endpoint : this._notifications.values()) {
            endpoint.close();
        }
        this._notifications.clear();
    }

    @Override
    public String dumpState(EventRegistration registration) {
        ReplicationNotificationClientEndpoint endpoint = this._notifications.get(registration);
        if (endpoint == null) {
            return "No such registration";
        }
        return endpoint.getNotificationReplicationNode().getAdmin().dumpState();
    }
}

