/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.events.durable;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.internal.events.durable.ReplicationNotificationClientEndpoint;
import com.gigaspaces.internal.transport.ITemplatePacket;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;

@InternalApi
public class NotifyCallHandler
implements BatchRemoteEventListener {
    private final Logger _logger;
    private final RemoteEventListener _listener;
    private final NotifyInfo _notifyInfo;
    private final ITemplatePacket _templatePacket;
    private final ReplicationNotificationClientEndpoint _endpoint;
    private final Object _lock = new Object();
    private boolean _closed;

    public NotifyCallHandler(RemoteEventListener listener, NotifyInfo notifyInfo, ITemplatePacket templatePacket, ReplicationNotificationClientEndpoint endpoint) {
        this._logger = endpoint.getLogger();
        this._listener = listener;
        this._notifyInfo = notifyInfo;
        this._templatePacket = templatePacket;
        this._endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBatch(BatchRemoteEvent batchEvent) {
        block8: {
            try {
                ((BatchRemoteEventListener)this._listener).notifyBatch(batchEvent);
            }
            catch (UnknownEventException e) {
                Object object = this._lock;
                synchronized (object) {
                    if (this._closed) {
                        return;
                    }
                    if (this._logger.isLoggable(Level.WARNING)) {
                        this._logger.log(Level.WARNING, this.getUnknownEventExceptionMessage(), e);
                    }
                    this.closeRegistration();
                    this._closed = true;
                }
            }
            catch (Exception e) {
                if (!this._logger.isLoggable(Level.WARNING)) break block8;
                this._logger.log(Level.WARNING, this.getExceptionMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(RemoteEvent theEvent) {
        block8: {
            try {
                this._listener.notify(theEvent);
            }
            catch (UnknownEventException e) {
                Object object = this._lock;
                synchronized (object) {
                    if (this._closed) {
                        return;
                    }
                    if (this._logger.isLoggable(Level.WARNING)) {
                        this._logger.log(Level.WARNING, this.getUnknownEventExceptionMessage(), e);
                    }
                    this.closeRegistration();
                    this._closed = true;
                }
            }
            catch (Exception e) {
                if (!this._logger.isLoggable(Level.WARNING)) break block8;
                this._logger.log(Level.WARNING, this.getExceptionMessage(), e);
            }
        }
    }

    private void closeRegistration() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NotifyCallHandler.this._endpoint.close();
            }
        }).start();
    }

    private String getUnknownEventExceptionMessage() {
        return "UnknownEventException occurred during call to client listener with template:" + this._templatePacket.toString() + ", template UID: " + this._notifyInfo.getTemplateUID() + ", performing unregistration";
    }

    private String getExceptionMessage() {
        return "Exception occurred during call to client listener with template:" + this._templatePacket.toString() + ", template UID: " + this._notifyInfo.getTemplateUID() + ", ignoring exception";
    }
}

