/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.events.durable;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.executors.RegisterReplicationNotificationTask;
import com.gigaspaces.internal.client.spaceproxy.executors.UnregisterReplicationNotificationTask;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNodeBuilder;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfig;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfigBuilder;
import com.gigaspaces.internal.cluster.node.impl.notification.NotificationReplicationDataConsumeFixFacade;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.processlog.ReliableAsyncAdaptiveProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.DistributedTransactionProcessingConfiguration;
import com.gigaspaces.internal.cluster.node.impl.router.DirectOnlyReplicationRouter;
import com.gigaspaces.internal.events.durable.AbstractReplicationNotificationInEntryHandler;
import com.gigaspaces.internal.events.durable.DurableNotificationLease;
import com.gigaspaces.internal.events.durable.DurableNotificationRegistrationException;
import com.gigaspaces.internal.events.durable.DurableNotificationReplicationNodeStateListener;
import com.gigaspaces.internal.events.durable.ReplicationNotificationBatchInEntryHandler;
import com.gigaspaces.internal.events.durable.ReplicationNotificationInBatchConsumptionHandler;
import com.gigaspaces.internal.events.durable.ReplicationNotificationInEntryHandler;
import com.gigaspaces.internal.events.durable.ReplicationNotificationInTransactionEntryHandler;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterUtils;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.space.requests.RegisterReplicationNotificationRequestInfo;
import com.gigaspaces.internal.space.requests.UnregisterReplicationNotificationRequestInfo;
import com.gigaspaces.internal.space.responses.RegisterReplicationNotificationResponseInfo;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.SharedHandlerProviderCache;
import com.gigaspaces.metrics.DummyMetricRegistrator;
import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.builder.SQLQueryTemplatePacket;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

@InternalApi
public class ReplicationNotificationClientEndpoint {
    private final Logger _logger;
    public static final String LOOKUP_NAME_PREFIX = "replication:NotifyDur:";
    private static final AtomicLong _eventIdGenerator = new AtomicLong(0L);
    private final ReplicationNode _notificationReplicationNode;
    private final IDirectSpaceProxy _remoteSpace;
    private final Object _template;
    private final ITemplatePacket _templatePacket;
    private final int _partitionId;
    private final int _numOfPartitions;
    private final NotifyInfo _notifyInfo;
    private final long _eventID;
    private final Uuid _spaceUID;
    private final IAsyncHandlerProvider _asyncProvider;
    private final DurableNotificationLease _lease;
    private final DurableNotificationReplicationNodeStateListener _stateListener;
    private final Object _lock = new Object();
    private boolean _closed;

    public ReplicationNotificationClientEndpoint(IDirectSpaceProxy remoteSpace, Object template, NotifyInfo info, EventSessionConfig sessionConfig, long lease) throws RemoteException {
        this._logger = remoteSpace.getDataEventsManager().getLogger();
        this._eventID = _eventIdGenerator.getAndIncrement();
        this._remoteSpace = remoteSpace;
        this._template = template;
        this._notifyInfo = info;
        this._notifyInfo.getOrInitTemplateUID();
        SpaceClusterInfo clusterInfo = this._remoteSpace.getSpaceClusterInfo();
        this._numOfPartitions = clusterInfo.isPartitioned() ? clusterInfo.getNumberOfPartitions() : 1;
        this._templatePacket = this.prepareTemplatePacket();
        this._partitionId = this.getPartitionId();
        this.validateConfiguration(remoteSpace, info);
        this._asyncProvider = SharedHandlerProviderCache.getSharedThreadPoolProviderCache().getProvider();
        this._lease = new DurableNotificationLease(this, lease, sessionConfig, this._asyncProvider);
        this._stateListener = new DurableNotificationReplicationNodeStateListener(sessionConfig, this._lease, this._asyncProvider, this._numOfPartitions, this._partitionId);
        this._notificationReplicationNode = this.createReplicationNode();
        this._spaceUID = this.registerNotificationReplicationNode();
        if (sessionConfig.isAutoRenew() && sessionConfig.getLeaseListener() != null) {
            this._stateListener.startDisconnectionMonitoring();
        }
        this._lease.startLeaseReaperIfNecessary();
    }

    public Logger getLogger() {
        return this._logger;
    }

    private void validateConfiguration(IDirectSpaceProxy remoteSpaceProxy, NotifyInfo info) {
        if (info.getFilter() != null) {
            throw new UnsupportedOperationException("IDelegatorFilter is not supported using durable notifications. Use space filters instead.");
        }
        if (!remoteSpaceProxy.getSpaceClusterInfo().isReplicated() || remoteSpaceProxy.getSpaceClusterInfo().isActiveActive()) {
            throw new UnsupportedOperationException("Durable notifications requires a partitioned primary backup topology.");
        }
        if (!this._templatePacket.getTypeDescriptor().isReplicable()) {
            throw new UnsupportedOperationException("Durable notifications on a non replicable template is currently not supported.");
        }
    }

    private ITemplatePacket prepareTemplatePacket() throws RemoteException {
        ObjectType templateObjectType = ObjectType.fromObject(this._template);
        ITemplatePacket templatePacket = this._remoteSpace.getDirectProxy().getTypeManager().getTemplatePacketFromObject(this._template, templateObjectType);
        if (this.preProcessQuery(this._template)) {
            templatePacket = this._remoteSpace.getQueryManager().getSQLTemplate((SQLQueryTemplatePacket)templatePacket, null);
        }
        templatePacket = templatePacket.clone();
        templatePacket.setSerializeTypeDesc(true);
        return templatePacket;
    }

    private boolean preProcessQuery(Object query) {
        if (query == null) {
            return false;
        }
        if (query instanceof SQLQuery) {
            SQLQuery sqlQuery = (SQLQuery)query;
            if (sqlQuery.isNullExpression() && sqlQuery.getObject() != null) {
                query = sqlQuery.getObject();
                return false;
            }
            return true;
        }
        return query instanceof SQLQueryTemplatePacket;
    }

    private int getPartitionId() {
        return PartitionedClusterUtils.getPartitionId(this._templatePacket.getRoutingFieldValue(), this._numOfPartitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Closing replication client endpoint");
            }
            if (this.getNotificationReplicationNode() != null) {
                this._stateListener.close();
                this.unregisterNotificationReplicationNode();
                this.getNotificationReplicationNode().close();
                this._closed = true;
            }
        }
    }

    private ReplicationNode createReplicationNode() {
        Uuid uuid = UuidFactory.generate();
        String hostname = SystemInfo.singleton().network().getHost().getHostName();
        String processId = "[" + SystemInfo.singleton().os().processId() + "]";
        String lookupName = LOOKUP_NAME_PREFIX + hostname + processId + "_" + uuid;
        ReplicationNodeBuilder replicationNodeBuilder = this.createReplicationNodeBuilder(uuid, lookupName);
        ReplicationNodeConfig replicationNodeConfig = ReplicationNodeConfigBuilder.getInstance().createNotificationConfig(this._remoteSpace.getName(), this._remoteSpace.getSpaceClusterInfo(), replicationNodeBuilder, this._partitionId, this._numOfPartitions);
        ReplicationNode replicationNode = new ReplicationNode(replicationNodeConfig, replicationNodeBuilder, lookupName, DummyMetricRegistrator.get());
        boolean isBatchListener = this._notifyInfo.getListener() instanceof BatchRemoteEventListener;
        AbstractReplicationNotificationInEntryHandler entryHandler = isBatchListener ? new ReplicationNotificationBatchInEntryHandler(this._notifyInfo, this._remoteSpace, this._eventID, this._templatePacket) : new ReplicationNotificationInEntryHandler(this._notifyInfo, this._remoteSpace, this._eventID, this._templatePacket, this);
        ReplicationNotificationInTransactionEntryHandler txnEntryHandler = new ReplicationNotificationInTransactionEntryHandler(entryHandler, isBatchListener);
        if (isBatchListener) {
            ReplicationNotificationInBatchConsumptionHandler batchHanlder = new ReplicationNotificationInBatchConsumptionHandler(this._notifyInfo, this._templatePacket, this);
            replicationNode.setInBatchConsumptionHandler(batchHanlder);
        }
        replicationNode.setInEntryHandler(entryHandler);
        replicationNode.setInEntryLeaseExpiredHandler(entryHandler);
        replicationNode.setInTransactionHandler(txnEntryHandler);
        replicationNode.getAdmin().setNodeStateListener(this._stateListener);
        replicationNode.getAdmin().setActive();
        replicationNode.getAdmin().getRouterAdmin().enableIncomingCommunication();
        return replicationNode;
    }

    private ReplicationNodeBuilder createReplicationNodeBuilder(Uuid uuid, String lookupName) {
        ReplicationNodeBuilder nodeBuilder = new ReplicationNodeBuilder();
        DirectOnlyReplicationRouter.Builder routerBuilder = new DirectOnlyReplicationRouter.Builder(lookupName, uuid);
        nodeBuilder.setReplicationRouterBuilder(routerBuilder);
        SpaceTypeManager typeManager = new SpaceTypeManager(new SpaceConfigReader(lookupName));
        NotificationReplicationDataConsumeFixFacade fixFacade = new NotificationReplicationDataConsumeFixFacade(this._remoteSpace);
        ReplicationPacketDataConsumer dataConsumer = new ReplicationPacketDataConsumer(typeManager, fixFacade, null);
        DistributedTransactionProcessingConfiguration distributedTransactionProcessingConfiguration = new DistributedTransactionProcessingConfiguration(60000L, -1L);
        nodeBuilder.setReplicationProcessLogBuilder(new ReliableAsyncAdaptiveProcessLogBuilder(dataConsumer, distributedTransactionProcessingConfiguration));
        nodeBuilder.setAsyncHandlerProvider(this._asyncProvider);
        return nodeBuilder;
    }

    private Uuid registerNotificationReplicationNode() throws DurableNotificationRegistrationException {
        Uuid result = null;
        try {
            ArrayList<AsyncFuture> futureList = new ArrayList<AsyncFuture>();
            int startIndex = this._partitionId == -1 ? 0 : this._partitionId;
            int endIndex = this._partitionId == -1 ? this._numOfPartitions - 1 : this._partitionId;
            for (int i = startIndex; i <= endIndex; ++i) {
                RegisterReplicationNotificationRequestInfo registerReplicationNotificationRequestInfo = new RegisterReplicationNotificationRequestInfo();
                registerReplicationNotificationRequestInfo.template = this._templatePacket;
                registerReplicationNotificationRequestInfo.viewStub = this.getNotificationReplicationNode().getAdmin().getRouterAdmin().getMyRouterStubHolder();
                registerReplicationNotificationRequestInfo.notifyInfo = new NotifyInfo(null, this._notifyInfo);
                registerReplicationNotificationRequestInfo.eventId = this._eventID;
                RegisterReplicationNotificationTask task = new RegisterReplicationNotificationTask(registerReplicationNotificationRequestInfo);
                try {
                    AsyncFuture future = this._remoteSpace.execute(task, i, null, null);
                    futureList.add(future);
                    continue;
                }
                catch (Exception e) {
                    throw new DurableNotificationRegistrationException(e.getMessage(), e);
                }
            }
            try {
                for (Future future : futureList) {
                    RegisterReplicationNotificationResponseInfo response = (RegisterReplicationNotificationResponseInfo)future.get();
                    if (response.exception != null) {
                        throw new DurableNotificationRegistrationException(response.exception.getMessage(), response.exception);
                    }
                    if (result != null) continue;
                    result = response.spaceUID;
                }
            }
            catch (ExecutionException e) {
                throw new DurableNotificationRegistrationException(e.getMessage(), e.getCause());
            }
            catch (InterruptedException e) {
                throw new DurableNotificationRegistrationException(e.getMessage(), e);
            }
        }
        catch (DurableNotificationRegistrationException e) {
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.log(Level.WARNING, "Notification replication node registration failed", e);
            }
            this.close();
            Throwable cause = e.getCause();
            if (cause instanceof AccessDeniedException) {
                throw (AccessDeniedException)cause;
            }
            throw e;
        }
        return result;
    }

    private void unregisterNotificationReplicationNode() {
        UnregisterReplicationNotificationRequestInfo request = new UnregisterReplicationNotificationRequestInfo();
        request.viewStubHolderName = this.getNotificationReplicationNode().getAdmin().getRouterAdmin().getMyRouterStubHolder().getMyEndpointDetails().getLookupName();
        int startIndex = this._partitionId == -1 ? 0 : this._partitionId;
        int endIndex = this._partitionId == -1 ? this._numOfPartitions - 1 : this._partitionId;
        ArrayList<AsyncFuture> futureList = new ArrayList<AsyncFuture>();
        for (int i = startIndex; i <= endIndex; ++i) {
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.log(Level.FINER, "sending replication node unregistration request to node on partition " + i);
            }
            UnregisterReplicationNotificationTask unregisterReplicationNotificationTask = new UnregisterReplicationNotificationTask(request);
            try {
                AsyncFuture future = this._remoteSpace.execute(unregisterReplicationNotificationTask, i, null, null);
                futureList.add(future);
                continue;
            }
            catch (Exception e) {
                if (!this._logger.isLoggable(Level.FINER)) continue;
                this._logger.log(Level.FINER, "Notification replication node unregistration failed", e);
            }
        }
        for (Future future : futureList) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Notification replication node unregistration interrupted", e);
                }
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (!this._logger.isLoggable(Level.FINE)) continue;
                this._logger.log(Level.FINE, "Notification replication node unregistration failed", e.getCause());
            }
        }
    }

    public long getEventID() {
        return this._eventID;
    }

    public Uuid getSpaceUID() {
        return this._spaceUID;
    }

    public DurableNotificationLease getLease() {
        return this._lease;
    }

    public ReplicationNode getNotificationReplicationNode() {
        return this._notificationReplicationNode;
    }
}

