/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.events.durable;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInBatchConsumptionHandler;
import com.gigaspaces.internal.events.durable.NotifyCallHandler;
import com.gigaspaces.internal.events.durable.ReplicationNotificationClientEndpoint;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import java.util.List;
import net.jini.core.event.RemoteEvent;

@InternalApi
public class ReplicationNotificationInBatchConsumptionHandler
implements IReplicationInBatchConsumptionHandler {
    private final BatchRemoteEventListener _listener;
    private final NotifyCallHandler _notifyCallHandler;

    public ReplicationNotificationInBatchConsumptionHandler(NotifyInfo notifyInfo, ITemplatePacket templatePacket, ReplicationNotificationClientEndpoint endpoint) {
        this._listener = (BatchRemoteEventListener)notifyInfo.getListener();
        this._notifyCallHandler = new NotifyCallHandler(this._listener, notifyInfo, templatePacket, endpoint);
    }

    @Override
    public void consumePendingOperationsInBatch(IReplicationInBatchContext context) {
        if (context.getPendingContext().isEmpty()) {
            context.currentConsumed();
            return;
        }
        List<EntryArrivedRemoteEvent> events = context.getPendingContext();
        RemoteEvent[] eventsNotification = events.toArray(new EntryArrivedRemoteEvent[events.size()]);
        BatchRemoteEvent batchEvent = new BatchRemoteEvent(eventsNotification);
        this._notifyCallHandler.notifyBatch(batchEvent);
        context.pendingConsumed();
    }
}

