/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.events.durable;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInTransactionHandler;
import com.gigaspaces.internal.cluster.node.handlers.ITransactionInContext;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalBatchExecutionCallback;
import com.gigaspaces.internal.events.durable.AbstractReplicationNotificationInEntryHandler;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.OperationID;
import java.util.Collection;
import java.util.List;

@InternalApi
public class ReplicationNotificationInTransactionEntryHandler
implements IReplicationInTransactionHandler,
ITransactionalBatchExecutionCallback {
    private final AbstractReplicationNotificationInEntryHandler _entryHandler;
    private final boolean _isBatchMode;

    public ReplicationNotificationInTransactionEntryHandler(AbstractReplicationNotificationInEntryHandler entryHandler, boolean isBatchMode) {
        this._entryHandler = entryHandler;
        this._isBatchMode = isBatchMode;
    }

    @Override
    public void inTransaction(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        List packetsData = (List)((Object)transactionContext);
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        for (IReplicationTransactionalPacketEntryData packetData : packetsData) {
            packetData.batchExecuteTransactional(batchContext, this);
        }
        if (!this._isBatchMode) {
            batchContext.currentConsumed();
        }
    }

    @Override
    public void writeEntry(IReplicationInBatchContext context, IEntryPacket entryPacket) throws Exception {
        this._entryHandler.handleWriteEntry(context, true, entryPacket);
    }

    @Override
    public void removeEntry(IReplicationInBatchContext context, IEntryPacket entryPacket) throws Exception {
        this._entryHandler.handleRemoveEntry(context, true, entryPacket);
    }

    @Override
    public void removeEntryByUID(IReplicationInBatchContext context, String typeName, String uid, OperationID operationID) throws Exception {
        this._entryHandler.handleRemoveEntryByUID(context, true, uid, false, operationID);
    }

    @Override
    public void updateEntry(IReplicationInBatchContext context, IEntryPacket entryPacket, IEntryPacket oldEntryPacket, boolean partialUpdate, short flags) throws Exception {
        this._entryHandler.handleUpdateEntry(context, true, entryPacket, oldEntryPacket, partialUpdate, false, flags);
    }

    @Override
    public void inTransactionPrepare(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void inTransactionCommit(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void inTransactionAbort(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeEntry(IReplicationInBatchContext context, String typeName, String uid, Object id, int version, int previousVersion, long timeToLive, int routingHash, Collection<SpaceEntryMutator> spaceEntryMutators, boolean isTransient, OperationID operationID) {
        throw new UnsupportedOperationException();
    }
}

