/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.exceptions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.multiple.query.QueryMultiplePartialFailureException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@InternalApi
public class BatchQueryException
extends QueryMultiplePartialFailureException
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final IEntryPacket[] _emptyResultsArray = new IEntryPacket[0];

    public BatchQueryException() {
    }

    protected BatchQueryException(List<?> results, List<Throwable> exceptions) {
        List<Throwable> exs = BatchQueryException.consume(results, exceptions);
        this.initialize(results, exs);
    }

    protected BatchQueryException(Object[] results, List<Throwable> exceptions) {
        if (results == null) {
            results = _emptyResultsArray;
        }
        ArrayList<Object> resultsList = new ArrayList<Object>(results.length);
        for (Object result : results) {
            resultsList.add(result);
        }
        List<Throwable> exs = BatchQueryException.consume(resultsList, exceptions);
        this.initialize(resultsList, exs);
    }

    protected BatchQueryException(Throwable cause) {
        this.initialize(null, new Throwable[]{cause});
    }

    private void initialize(List<?> results, List<Throwable> causes) {
        Throwable[] causesArray = causes == null ? null : causes.toArray(new Throwable[causes.size()]);
        Object[] resultsArray = results == null ? _emptyResultsArray : results.toArray(new IEntryPacket[results.size()]);
        this.initialize(resultsArray, causesArray);
    }

    private void initialize(Object[] results, Throwable[] causes) {
        this.setResults(results == null ? _emptyResultsArray : results);
        this.setCauses(causes);
    }

    @Override
    public Throwable[] getCauses() {
        return super.getCauses();
    }

    @Override
    public Object[] getResults() {
        return super.getResults();
    }

    @Override
    public void setResults(Object[] results) {
        super.setResults(results);
    }

    public Throwable getMajorityCause() {
        return BatchQueryException.getMajorityCause(this.getCauses());
    }

    public Throwable getOriginalMajorityCause() {
        return BatchQueryException.getOriginalMajorityCause(this.getCauses());
    }

    public boolean containsCause(Class<? extends Throwable> exceptionClass) {
        return BatchQueryException.containsCause(exceptionClass, this.getCauses());
    }

    @Override
    public String getMessage() {
        int failures;
        HashMap errorTypes = new HashMap();
        HashMap errors = new HashMap();
        if (this.getCauses() == null) {
            failures = 0;
        } else {
            failures = this.getCauses().length;
            for (Throwable error : this.getCauses()) {
                Class<?> key = error.getClass();
                if (errorTypes.containsKey(key)) {
                    errorTypes.put(key, 1 + (Integer)errorTypes.get(key));
                    continue;
                }
                errorTypes.put(error.getClass(), 1);
                errors.put(error.getClass(), error);
            }
        }
        StringBuilder sb = new StringBuilder("Success:");
        sb.append(this.getResults() == null ? 0 : this.getResults().length);
        sb.append(", errors:").append(failures);
        sb.append(", [");
        for (Map.Entry entry : errorTypes.entrySet()) {
            sb.append(entry.getKey());
            sb.append(':');
            sb.append(entry.getValue());
            sb.append("\nStackTrace: ");
            Throwable t = (Throwable)errors.get(entry.getKey());
            t.printStackTrace(new PrintWriter(new StringBuilderWriter(sb)));
            sb.append(' ');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setResults(IOUtils.readEntryPacketArray(in));
        this.setCauses(IOUtils.readThrowableArray(in));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObjectArray(out, this.getResults());
        IOUtils.writeObjectArray(out, this.getCauses());
    }

    private static List<Throwable> consume(List results, List<Throwable> exceptions) {
        LinkedList<Throwable> exs = new LinkedList<Throwable>();
        for (Throwable e : exceptions) {
            if (e instanceof QueryMultiplePartialFailureException) {
                QueryMultiplePartialFailureException qmpfe = (QueryMultiplePartialFailureException)e;
                for (Object value : qmpfe.getResults()) {
                    results.add(value);
                }
                for (Throwable t : qmpfe.getCauses()) {
                    exs.add(t);
                }
                continue;
            }
            exs.add(e);
        }
        return exs;
    }

    private static Throwable getMajorityCause(Throwable[] causes) {
        if (causes == null || causes.length == 0) {
            return null;
        }
        HashMap<String, Integer> exceptionCount = new HashMap<String, Integer>();
        HashMap<String, Throwable> exceptionInstances = new HashMap<String, Throwable>();
        for (Throwable ex : causes) {
            String exClassName = ex.getClass().getName();
            if (!exceptionCount.containsKey(exClassName)) {
                exceptionCount.put(exClassName, 1);
                exceptionInstances.put(exClassName, ex);
                continue;
            }
            int count = (Integer)exceptionCount.get(exClassName);
            exceptionCount.put(exClassName, ++count);
        }
        int majority = 0;
        Throwable majorityException = null;
        for (Map.Entry countEntry : exceptionCount.entrySet()) {
            int value = (Integer)countEntry.getValue();
            if (value <= majority) continue;
            majority = value;
            majorityException = (Throwable)exceptionInstances.get(countEntry.getKey());
        }
        return majorityException;
    }

    private static Throwable getOriginalMajorityCause(Throwable[] causes) {
        if (causes == null || causes.length == 0) {
            return null;
        }
        Throwable[] originalCauses = new Throwable[causes.length];
        for (int i = 0; i < causes.length; ++i) {
            Throwable originalCause;
            for (originalCause = causes[i]; originalCause.getCause() != null && originalCause.getCause() != originalCause; originalCause = originalCause.getCause()) {
            }
            originalCauses[i] = originalCause;
        }
        return BatchQueryException.getMajorityCause(originalCauses);
    }

    private static boolean containsCause(Class<? extends Throwable> exceptionClass, Throwable[] causes) {
        if (causes == null) {
            return false;
        }
        for (Throwable ex : causes) {
            if (!exceptionClass.isAssignableFrom(ex.getClass())) continue;
            return true;
        }
        return false;
    }

    private static class StringBuilderWriter
    extends Writer {
        private final StringBuilder builder;

        public StringBuilderWriter(StringBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.builder.append(cbuf, off, len);
        }
    }
}

