/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.exceptions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class PartitionedExecutionExceptionsCollection {
    private final Map<Integer, Exception> _exceptions = new HashMap<Integer, Exception>();

    public void add(int partitionId, Exception partitionException) {
        this._exceptions.put(partitionId, partitionException);
    }

    public <T extends RuntimeException> void throwIfAny(Class<T> type) {
        RuntimeException exception = (RuntimeException)this.getIfExists(type);
        if (exception != null) {
            throw exception;
        }
    }

    private <T extends Throwable> T getIfExists(Class<T> type) {
        for (Exception exception : this._exceptions.values()) {
            if (!type.isInstance(exception)) continue;
            return (T)exception;
        }
        return null;
    }

    public String getDescription() {
        if (this._exceptions.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Exception> partition : this._exceptions.entrySet()) {
            sb.append("Partition #").append(partition.getKey()).append(": ").append(partition.getValue()).append(StringUtils.NEW_LINE);
        }
        return sb.toString();
    }
}

