/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.exceptions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.WriteMultipleException;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.multiple.write.IWriteResult;
import net.jini.core.lease.Lease;

@InternalApi
public class WriteResultImpl
implements WriteMultipleException.IWriteResult {
    static final long serialVersionUID = 0L;
    private IWriteResult.ResultType _type = IWriteResult.ResultType.LEASE;
    private Throwable _error;
    private Lease _lease;

    public static WriteResultImpl createResult(Lease lease, Throwable error) {
        return error != null ? WriteResultImpl.createErrorResult(error) : WriteResultImpl.createLeaseResult(lease);
    }

    public static WriteResultImpl createErrorResult(Throwable e) {
        WriteResultImpl r = new WriteResultImpl();
        r.setError(e);
        r.setType(IWriteResult.ResultType.ERROR);
        return r;
    }

    public static WriteResultImpl createLeaseResult(Lease lease) {
        WriteResultImpl r = new WriteResultImpl();
        r.setLease(lease);
        r.setType(IWriteResult.ResultType.LEASE);
        return r;
    }

    @Override
    public IWriteResult.ResultType getResultType() {
        return this._type;
    }

    @Override
    public boolean isError() {
        return this._type == IWriteResult.ResultType.ERROR;
    }

    public void setType(IWriteResult.ResultType type) {
        this._type = type;
    }

    @Override
    public Throwable getError() {
        return this._error;
    }

    public void setError(Throwable error) {
        this._error = error;
        if (error != null) {
            this.setType(IWriteResult.ResultType.ERROR);
        }
    }

    @Override
    public Lease getLease() {
        return this._lease;
    }

    public void setLease(Lease lease) {
        this._lease = lease;
    }

    public String toString() {
        if (this.isError()) {
            return String.valueOf(this._error);
        }
        return String.valueOf(this._lease);
    }

    @Override
    public LeaseContext<?> getLeaseContext() {
        return (LeaseContext)this._lease;
    }
}

