/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.extension;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.extension.XapExtension;
import com.gigaspaces.logger.LogHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.boot.LoggableClassLoader;

@InternalApi
public class XapExtensionActivator {
    private static final Logger logger = Logger.getLogger(XapExtensionActivator.class.getName());

    public static synchronized void scanAndActivate(ClassLoader classLoader, String key) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Scanning for " + key + " in class loader " + XapExtensionActivator.toString(classLoader));
        }
        long startTime = System.currentTimeMillis();
        Map<URL, Properties> xapProperties = XapExtensionActivator.loadManifestsEntryAttributes(classLoader, "xap");
        Set<String> extensions = XapExtensionActivator.loadSet(xapProperties, key, ",");
        XapExtensionActivator.activate(classLoader, extensions);
        LogHelper.logDuration((Logger)logger, (Level)Level.FINE, (long)startTime, (String)("Finished scanning for extensions in class loader " + XapExtensionActivator.toString(classLoader)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void activate(ClassLoader classLoader, Set<String> extensions) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Activating " + extensions.size() + " extensions...");
            }
            for (String extensionName : extensions) {
                XapExtensionActivator.activate(classLoader, extensionName);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static void activate(ClassLoader classLoader, String extensionName) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Activating extension " + extensionName);
        }
        try {
            Class<?> extensionClass = classLoader.loadClass(extensionName);
            Object instance = extensionClass.newInstance();
            XapExtension extension = (XapExtension)instance;
            extension.activate();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Activated extension " + extensionName);
            }
        }
        catch (NoClassDefFoundError e) {
            logger.log(Level.WARNING, "Failed to activate extension " + extensionName + " - " + e);
            throw new RuntimeException("Failed to activate extension " + extensionName, e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Failed to activate extension " + extensionName + " - " + e);
            throw new RuntimeException("Failed to activate extension " + extensionName, e);
        }
        catch (InstantiationException e) {
            logger.log(Level.WARNING, "Failed to activate extension " + extensionName + " - " + e);
            throw new RuntimeException("Failed to activate extension " + extensionName, e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "Failed to activate extension " + extensionName + " - " + e);
            throw new RuntimeException("Failed to activate extension " + extensionName, e);
        }
    }

    private static Set<String> loadSet(Map<URL, Properties> xapProperties, String name, String separator) {
        HashSet<String> result = new HashSet<String>();
        for (Properties properties : xapProperties.values()) {
            String[] tokens;
            String value = properties.getProperty(name);
            if (value == null) continue;
            for (String token : tokens = value.split(separator)) {
                result.add(token.trim());
            }
        }
        return result;
    }

    private static Map<URL, Properties> loadManifestsEntryAttributes(ClassLoader classLoader, String entryName) {
        try {
            HashMap<URL, Properties> result = new HashMap<URL, Properties>();
            Enumeration<URL> resources = classLoader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Properties xapProperties = XapExtensionActivator.loadManifestEntryAttributes(url, entryName);
                if (xapProperties == null) continue;
                result.put(url, xapProperties);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load manifest information", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadManifestEntryAttributes(URL url, String entryName) throws IOException {
        Properties result = null;
        try (InputStream inputStream = null;){
            Manifest manifest;
            Attributes attributes;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Loading manifest from " + url);
            }
            if ((attributes = (manifest = new Manifest(inputStream = url.openStream())).getAttributes(entryName)) != null) {
                result = new Properties();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Found " + attributes.size() + " attributes for entry '" + entryName + "'");
                }
                for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
                    result.setProperty(entry.getKey().toString(), entry.getValue().toString());
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "Found entry " + entry.getKey() + " => " + entry.getValue());
                }
            }
        }
        return result;
    }

    private static String toString(ClassLoader classLoader) {
        return classLoader instanceof LoggableClassLoader ? ((LoggableClassLoader)classLoader).getLogName() : classLoader.toString();
    }
}

