/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.extension;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.executors.AddTypeIndexesTask;
import com.gigaspaces.internal.client.spaceproxy.executors.GetTypeDescriptorTask;
import com.gigaspaces.internal.client.spaceproxy.executors.RegisterReplicationLocalViewTask;
import com.gigaspaces.internal.client.spaceproxy.executors.RegisterReplicationNotificationTask;
import com.gigaspaces.internal.client.spaceproxy.executors.RegisterTypeDescriptorTask;
import com.gigaspaces.internal.client.spaceproxy.executors.SystemTask;
import com.gigaspaces.internal.client.spaceproxy.executors.UnregisterReplicationLocalViewTask;
import com.gigaspaces.internal.client.spaceproxy.executors.UnregisterReplicationNotificationTask;
import com.gigaspaces.internal.cluster.node.impl.ReplicationUtils;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfigBuilder;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationRouterBuilderFactory;
import com.gigaspaces.internal.extension.CustomSerializer;
import com.gigaspaces.internal.extension.XapExtensionActivator;
import com.gigaspaces.internal.server.space.executors.SpaceActionExecutor;
import com.gigaspaces.internal.server.space.executors.SpaceAddTypeIndexesExecutor;
import com.gigaspaces.internal.server.space.executors.SpaceGetTypeDescriptorExecutor;
import com.gigaspaces.internal.server.space.executors.SpaceRegisterReplicationLocalViewExecutor;
import com.gigaspaces.internal.server.space.executors.SpaceRegisterReplicationNotificationExecutor;
import com.gigaspaces.internal.server.space.executors.SpaceRegisterTypeDescriptorExecutor;
import com.gigaspaces.internal.server.space.executors.SpaceUnregisterReplicationLocalViewExecutor;
import com.gigaspaces.internal.server.space.executors.SpaceUnregisterReplicationNotificationExecutor;
import com.gigaspaces.internal.utils.XapRuntimeReporter;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.client.SpaceFinderListener;
import java.io.Externalizable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class XapExtensions {
    private static final Logger logger = Logger.getLogger(XapExtensions.class.getName());
    private XapRuntimeReporter xapRuntimeReporter = new XapRuntimeReporter();
    private SpaceFinderListener spaceFinderListener;
    private ReplicationNodeConfigBuilder replicationNodeConfigBuilder = new ReplicationNodeConfigBuilder();
    private ReplicationRouterBuilderFactory replicationRouterBuilderFactory = new ReplicationRouterBuilderFactory();
    private ReplicationUtils replicationUtils = new ReplicationUtils();
    private final Map<Class<? extends SystemTask>, SpaceActionExecutor> actionExecutors = new HashMap<Class<? extends SystemTask>, SpaceActionExecutor>();
    private final Map<Class<? extends Externalizable>, CustomSerializer> customSerializers = new HashMap<Class<? extends Externalizable>, CustomSerializer>();
    private static XapExtensions instance;

    public static synchronized XapExtensions getInstance() {
        if (instance == null) {
            instance = new XapExtensions();
            XapExtensionActivator.scanAndActivate(XapExtensions.class.getClassLoader(), "extensions-core");
        }
        return instance;
    }

    private XapExtensions() {
        this.registerSystemTaskExecutor(GetTypeDescriptorTask.class, new SpaceGetTypeDescriptorExecutor());
        this.registerSystemTaskExecutor(RegisterTypeDescriptorTask.class, new SpaceRegisterTypeDescriptorExecutor());
        this.registerSystemTaskExecutor(AddTypeIndexesTask.class, new SpaceAddTypeIndexesExecutor());
        this.registerSystemTaskExecutor(RegisterReplicationLocalViewTask.class, new SpaceRegisterReplicationLocalViewExecutor());
        this.registerSystemTaskExecutor(UnregisterReplicationLocalViewTask.class, new SpaceUnregisterReplicationLocalViewExecutor());
        this.registerSystemTaskExecutor(RegisterReplicationNotificationTask.class, new SpaceRegisterReplicationNotificationExecutor());
        this.registerSystemTaskExecutor(UnregisterReplicationNotificationTask.class, new SpaceUnregisterReplicationNotificationExecutor());
    }

    public ReplicationRouterBuilderFactory getReplicationRouterBuilderFactory() {
        return this.replicationRouterBuilderFactory;
    }

    public void setReplicationRouterBuilderFactory(ReplicationRouterBuilderFactory factory) {
        this.replicationRouterBuilderFactory = factory;
    }

    public SpaceFinderListener getSpaceFinderListener() {
        return this.spaceFinderListener;
    }

    public void setSpaceFinderListener(SpaceFinderListener listener) {
        this.spaceFinderListener = listener;
    }

    public ReplicationNodeConfigBuilder getReplicationNodeConfigBuilder() {
        return this.replicationNodeConfigBuilder;
    }

    public void setReplicationNodeConfigBuilder(ReplicationNodeConfigBuilder configBuilder) {
        this.replicationNodeConfigBuilder = configBuilder;
    }

    public ReplicationUtils getReplicationUtils() {
        return this.replicationUtils;
    }

    public void setReplicationUtils(ReplicationUtils replicationUtils) {
        this.replicationUtils = replicationUtils;
    }

    public Map<Class<? extends SystemTask>, SpaceActionExecutor> getActionExecutors() {
        return Collections.unmodifiableMap(this.actionExecutors);
    }

    public void registerSystemTaskExecutor(Class<? extends SystemTask> taskClass, SpaceActionExecutor executor) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Registering system task" + taskClass.getName() + " => " + executor.getClass().getName());
        }
        this.actionExecutors.put(taskClass, executor);
    }

    public <T extends Externalizable> CustomSerializer<T> getCustomSerializer(Class<T> c, PlatformLogicalVersion version) {
        CustomSerializer customSerializer = this.customSerializers.get(c);
        return customSerializer != null && customSerializer.supports(version) ? customSerializer : null;
    }

    public <T extends Externalizable> void registerCustomSerializer(Class<T> c, CustomSerializer<T> serializer) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Registering custom serializer " + c.getName() + " => " + serializer.getClass().getName());
        }
        this.customSerializers.put(c, serializer);
    }

    public XapRuntimeReporter getXapRuntimeReporter() {
        return this.xapRuntimeReporter;
    }

    public void registerXapRuntimeReporter(XapRuntimeReporter reporter) {
        this.xapRuntimeReporter = reporter;
    }
}

