/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.rmi.server.RMIClassLoader;

@InternalApi
public class AnnotatedObjectInputStream
extends ObjectInputStream {
    public AnnotatedObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass classDesc, boolean readAnnotation, String codebase) throws IOException, ClassNotFoundException {
        if (readAnnotation) {
            codebase = this.readAnnotation(classDesc);
        }
        String name = classDesc.getName();
        try {
            return ClassLoaderHelper.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return RMIClassLoader.loadClass(codebase, name, Thread.currentThread().getContextClassLoader());
        }
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        return this.resolveClass(classDesc, true, null);
    }

    protected String readAnnotation(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return (String)this.readUnshared();
        }
        catch (ClassCastException e) {
            InvalidObjectException ioe = new InvalidObjectException("Annotation is not String or null");
            ioe.initCause(e);
            throw ioe;
        }
    }
}

