/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.CompressedMarshObject;
import com.gigaspaces.internal.io.GSByteArrayInputStream;
import com.gigaspaces.internal.io.GSByteArrayOutputStream;
import com.gigaspaces.internal.io.ISmartLengthBasedCacheCallback;
import com.gigaspaces.internal.io.MarshObject;
import com.gigaspaces.internal.io.MarshObjectConvertorResource;
import com.gigaspaces.internal.io.SmartByteArrayCache;
import com.gigaspaces.internal.io.SmartLengthBasedCache;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResourceFactory;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResourcePool;
import com.j_spaces.kernel.pool.IResourceFactory;
import com.j_spaces.kernel.pool.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

@InternalApi
public class CompressedMarshObjectConvertor
extends Resource
implements MarshObjectConvertorResource {
    private int zipEntryCounter;
    private static final int MAX_ENTRIES = 100;
    private int _level;
    private GSByteArrayOutputStream _bao;
    private final SmartByteArrayCache _byteArrayCache;
    private ZipOutputStream _zo;
    private ObjectOutputStream _oo;
    private GSByteArrayInputStream _bai;
    private ZipInputStream _zi;
    private ObjectInputStream _oi;
    private static CompressedMarshObjectConvertorFactory _factory = null;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private static final byte[] DUMMY_BUFFER = new byte[0];

    private static SmartByteArrayCache createSerializationByteArrayCache(ISmartLengthBasedCacheCallback cacheCallback) {
        int maxBufferSize = Integer.getInteger("com.gs.client.storage-type-serialization.cache.buffer-size", 0x4000000);
        double expungeRatio = Double.parseDouble(System.getProperty("com.gs.client.storage-type-serialization.cache.buffer-expunge-ratio", String.valueOf(0.5)));
        int expungeCount = Integer.getInteger("com.gs.client.storage-type-serialization.cache.buffer-expunge-times-threshold", 20);
        return new SmartByteArrayCache(maxBufferSize, expungeRatio, expungeCount, 1024, cacheCallback);
    }

    public CompressedMarshObjectConvertor(int level) {
        this(level, null);
    }

    public CompressedMarshObjectConvertor(int level, ISmartLengthBasedCacheCallback cacheCallback) {
        block2: {
            this.zipEntryCounter = 0;
            this._byteArrayCache = CompressedMarshObjectConvertor.createSerializationByteArrayCache(cacheCallback);
            this._level = level;
            try {
                this._bao = new GSByteArrayOutputStream();
                this._zo = new ZipOutputStream(this._bao);
                this._zo.setLevel(this._level);
                this._zo.putNextEntry(new ZipEntry(Integer.toString(this.zipEntryCounter++)));
                this._oo = this.getObjectOutputStream(this._zo);
                this._bai = new GSByteArrayInputStream(new byte[0]);
                this._zi = new ZipInputStream(this._bai);
                this.getObject(this.getMarshObjectInternal("", true));
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private MarshObject getMarshObjectInternal(Object o, boolean init) throws IOException {
        byte[] bc;
        if (init) {
            bc = this.serializeToByteArray(o);
        } else {
            this._bao.setBuffer((byte[])this._byteArrayCache.get());
            this._bao.reset();
            if (++this.zipEntryCounter < 100) {
                this._zo.putNextEntry(new ZipEntry(Integer.toString(this.zipEntryCounter)));
                this._oo.reset();
            } else {
                this.zipEntryCounter = 0;
                this._zo = new ZipOutputStream(this._bao);
                this._zo.setLevel(this._level);
                this._zo.putNextEntry(new ZipEntry(Integer.toString(this.zipEntryCounter)));
                this._oo = this.getObjectOutputStream(this._zo);
                this._zo.closeEntry();
                this._bao.reset();
                this._zo.putNextEntry(new ZipEntry(Integer.toString(++this.zipEntryCounter)));
                this._oo.reset();
            }
            bc = this.serializeToByteArray(o);
            this._byteArrayCache.notifyUsedSize(bc.length);
            this._bao.setBuffer(DUMMY_BUFFER);
        }
        return new CompressedMarshObject(bc);
    }

    protected byte[] serializeToByteArray(Object o) throws IOException {
        this._oo.writeObject(o);
        this._oo.flush();
        this._zo.closeEntry();
        return this._bao.toByteArray();
    }

    @Override
    public MarshObject getMarshObject(Object o) throws IOException {
        return this.getMarshObjectInternal(o, false);
    }

    @Override
    public Object getObject(MarshObject marsh) throws IOException, ClassNotFoundException {
        if (!(marsh instanceof CompressedMarshObject)) {
            throw new IOException("Can decompress only CompressedMarshObject");
        }
        this._bai.setBuffer(marsh.getBytes());
        this._zi.getNextEntry();
        if (this._oi == null) {
            this._oi = this.getObjectInputStream(this._zi);
        }
        Object object = this._oi.readObject();
        this._zi.getNextEntry();
        this._bai.setBuffer(DUMMY_BUFFER);
        return object;
    }

    protected ObjectOutputStream getObjectOutputStream(OutputStream is) throws IOException {
        return new ObjectOutputStream(is);
    }

    protected ObjectInputStream getObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStream(is);
    }

    @Override
    public void clear() {
    }

    public static IResourceFactory<CompressedMarshObjectConvertor> getFactory() {
        if (_factory == null) {
            _factory = new CompressedMarshObjectConvertorFactory();
        }
        return _factory;
    }

    @Override
    public long getUsedMemory() {
        return this._byteArrayCache.getLength();
    }

    protected static class CompressedMarshObjectConvertorFactory
    implements IMemoryAwareResourceFactory<CompressedMarshObjectConvertor> {
        protected CompressedMarshObjectConvertorFactory() {
        }

        @Override
        public CompressedMarshObjectConvertor allocate() {
            return new CompressedMarshObjectConvertor(9);
        }

        @Override
        public CompressedMarshObjectConvertor allocate(IMemoryAwareResourcePool resourcePool) {
            return new CompressedMarshObjectConvertor(9, SmartLengthBasedCache.toCacheCallback(resourcePool));
        }
    }
}

