/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.CompressedMarshObjectConvertor;
import com.gigaspaces.internal.io.ContextClassResolverObjectInputStream;
import com.gigaspaces.internal.io.ISmartLengthBasedCacheCallback;
import com.gigaspaces.internal.io.SmartLengthBasedCache;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResourceFactory;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResourcePool;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

@InternalApi
public class ContextClassResolverCompressedMarshObjectConvertor
extends CompressedMarshObjectConvertor {
    private static ContextClassResolverCompressedMarshObjectConvertorFactory _factory;

    public ContextClassResolverCompressedMarshObjectConvertor(int level) {
        super(level);
    }

    public ContextClassResolverCompressedMarshObjectConvertor(int level, ISmartLengthBasedCacheCallback cacheCallback) {
        super(level, cacheCallback);
    }

    @Override
    protected ObjectInputStream getObjectInputStream(InputStream is) throws IOException {
        return new ContextClassResolverObjectInputStream(is);
    }

    public static IMemoryAwareResourceFactory<CompressedMarshObjectConvertor> getFactory() {
        if (_factory == null) {
            _factory = new ContextClassResolverCompressedMarshObjectConvertorFactory();
        }
        return _factory;
    }

    private static class ContextClassResolverCompressedMarshObjectConvertorFactory
    extends CompressedMarshObjectConvertor.CompressedMarshObjectConvertorFactory {
        private ContextClassResolverCompressedMarshObjectConvertorFactory() {
        }

        @Override
        public CompressedMarshObjectConvertor allocate() {
            return new ContextClassResolverCompressedMarshObjectConvertor(9);
        }

        @Override
        public ContextClassResolverCompressedMarshObjectConvertor allocate(IMemoryAwareResourcePool resourcePool) {
            return new ContextClassResolverCompressedMarshObjectConvertor(9, SmartLengthBasedCache.toCacheCallback(resourcePool));
        }
    }
}

