/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.ContextClassResolverObjectInputStream;
import com.gigaspaces.internal.io.ISmartLengthBasedCacheCallback;
import com.gigaspaces.internal.io.MarshObjectConvertor;
import com.gigaspaces.internal.io.SmartLengthBasedCache;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResourceFactory;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResourcePool;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

@InternalApi
public class ContextClassResolverMarshObjectConvertor
extends MarshObjectConvertor {
    private static ContextClassResolverMarshObjectConvertorFactory _factory;

    public ContextClassResolverMarshObjectConvertor() {
    }

    public ContextClassResolverMarshObjectConvertor(ISmartLengthBasedCacheCallback cacheCallback) {
        super(cacheCallback);
    }

    @Override
    protected ObjectInputStream getObjectInputStream(InputStream is) throws IOException {
        return new ContextClassResolverObjectInputStream(is);
    }

    public static IMemoryAwareResourceFactory<MarshObjectConvertor> getFactory() {
        if (_factory == null) {
            _factory = new ContextClassResolverMarshObjectConvertorFactory();
        }
        return _factory;
    }

    private static class ContextClassResolverMarshObjectConvertorFactory
    extends MarshObjectConvertor.MarshObjectConvertorFactory {
        private ContextClassResolverMarshObjectConvertorFactory() {
        }

        @Override
        public MarshObjectConvertor allocate() {
            return new ContextClassResolverMarshObjectConvertor();
        }

        @Override
        public MarshObjectConvertor allocate(IMemoryAwareResourcePool resourcePool) {
            return new ContextClassResolverMarshObjectConvertor(SmartLengthBasedCache.toCacheCallback(resourcePool));
        }
    }
}

