/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.BootIOUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

@InternalApi
public class FileUtils {
    public static File[] findFiles(File folder, final String prefix, final String suffix) {
        return folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                String fileName = file.getName();
                if (prefix != null && !fileName.startsWith(prefix)) {
                    return false;
                }
                return suffix == null || fileName.endsWith(suffix);
            }
        });
    }

    public static boolean deleteFileOrDirectoryIfExists(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            for (File file : BootIOUtils.listFiles((File)fileOrDirectory)) {
                FileUtils.deleteFileOrDirectoryIfExists(file);
            }
        }
        return fileOrDirectory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        FileChannel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            sourceChannel = new FileInputStream(sourceFile).getChannel();
            destChannel = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destChannel).transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (destChannel != null) {
                destChannel.close();
            }
        }
    }
}

