/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import java.io.InputStream;

@InternalApi
public class GSByteArrayInputStream
extends InputStream {
    protected byte[] _buffer;
    protected int _position;
    protected int _count;

    public GSByteArrayInputStream(byte[] buffer) {
        this.setBuffer(buffer);
    }

    public void setBuffer(byte[] buffer) {
        this.setBuffer(buffer, buffer.length);
    }

    public void setBuffer(byte[] buffer, int count) {
        this._buffer = buffer;
        this._position = 0;
        this._count = count;
    }

    @Override
    public void reset() {
        this._position = 0;
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    @Override
    public int read() {
        return this._position < this._count ? this.readUnsignedByte() : -1;
    }

    public byte readByte() {
        return this._buffer[this._position++];
    }

    public int readUnsignedByte() {
        return this._buffer[this._position++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this._position >= this._count) {
            return -1;
        }
        if (this._position + len > this._count) {
            len = this._count - this._position;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this._buffer, this._position, b, off, len);
        this._position += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if ((long)this._position + n > (long)this._count) {
            n = this._count - this._position;
        }
        if (n < 0L) {
            return 0L;
        }
        this._position = (int)((long)this._position + n);
        return n;
    }

    @Override
    public int available() {
        return this._count - this._position;
    }
}

