/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.IntegerObjectMap;
import com.gigaspaces.internal.collections.ObjectIntegerMap;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.internal.io.IOArrayException;
import com.gigaspaces.internal.io.MarshalInputStream;
import com.gigaspaces.internal.io.MarshalOutputStream;
import com.gigaspaces.internal.serialization.BooleanClassSerializer;
import com.gigaspaces.internal.serialization.ByteArrayClassSerializer;
import com.gigaspaces.internal.serialization.ByteClassSerializer;
import com.gigaspaces.internal.serialization.CharacterClassSerializer;
import com.gigaspaces.internal.serialization.DoubleClassSerializer;
import com.gigaspaces.internal.serialization.FloatClassSerializer;
import com.gigaspaces.internal.serialization.IClassSerializer;
import com.gigaspaces.internal.serialization.IntegerClassSerializer;
import com.gigaspaces.internal.serialization.LongClassSerializer;
import com.gigaspaces.internal.serialization.NullClassSerializer;
import com.gigaspaces.internal.serialization.ObjectClassSerializer;
import com.gigaspaces.internal.serialization.ShortClassSerializer;
import com.gigaspaces.internal.serialization.StringClassSerializer;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ISwapExternalizable;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.utils.CodeChangeUtilities;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jini.rio.boot.CodeChangeClassLoadersManager;
import org.jini.rio.boot.ServiceClassLoader;
import org.jini.rio.boot.SupportCodeChangeAnnotationContainer;

@InternalApi
public class IOUtils {
    private static ByteArrayOutputStream outStream = new ByteArrayOutputStream(65535);
    private static final Map<Class<?>, IClassSerializer<?>> _typeCache;
    private static final Map<Byte, IClassSerializer<?>> _codeCache;
    private static final ObjectIntegerMap<Class<?>> _classToCode;
    private static final IntegerObjectMap<Class<?>> _codeToClass;
    private static int _swapExtenKey;
    private static final IClassSerializer<?> _defaultSerializer;

    private static void register(Class<?> type, IClassSerializer<?> serializer) {
        _typeCache.put(type, serializer);
        _codeCache.put(serializer.getCode(), serializer);
    }

    public static Object objectFromByteBuffer(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(buffer);
        ObjectInputStream in = new ObjectInputStream(inStream);
        Object retval = in.readObject();
        in.close();
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToByteBuffer(Object obj) throws Exception {
        byte[] result = null;
        ByteArrayOutputStream byteArrayOutputStream = outStream;
        synchronized (byteArrayOutputStream) {
            outStream.reset();
            ObjectOutputStream out = new ObjectOutputStream(outStream);
            out.writeObject(obj);
            out.flush();
            result = outStream.toByteArray();
            out.close();
        }
        return result;
    }

    public static Object deepClone(Object obj) {
        try {
            byte[] bArray = IOUtils.objectToByteBuffer(obj);
            return IOUtils.objectFromByteBuffer(bArray);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to perform deep clone on [" + obj + "] object. Check that the all object context are implements java.io.Serializable.", ex);
        }
    }

    public static void writeUUID(ObjectOutput out, UUID value) throws IOException {
        out.writeLong(value.getLeastSignificantBits());
        out.writeLong(value.getMostSignificantBits());
    }

    public static UUID readUUID(ObjectInput in) throws IOException {
        long least = in.readLong();
        long most = in.readLong();
        return new UUID(most, least);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void marshalValue(Class type, Object value, ObjectOutput out) throws IOException {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                out.writeInt((Integer)value);
                return;
            } else if (type == Boolean.TYPE) {
                out.writeBoolean((Boolean)value);
                return;
            } else if (type == Long.TYPE) {
                out.writeLong((Long)value);
                return;
            } else if (type == Short.TYPE) {
                out.writeShort(((Short)value).shortValue());
                return;
            } else if (type == Float.TYPE) {
                out.writeFloat(((Float)value).floatValue());
                return;
            } else if (type == Double.TYPE) {
                out.writeDouble((Double)value);
                return;
            } else if (type == Character.TYPE) {
                out.writeChar(((Character)value).charValue());
                return;
            } else {
                if (type != Byte.TYPE) throw new AssertionError((Object)("Unrecognized primitive type: " + type));
                out.writeByte(((Byte)value).byteValue());
            }
            return;
        } else {
            out.writeObject(value);
        }
    }

    public static Object unmarshalValue(Class type, ObjectInput in) throws IOException, ClassNotFoundException {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return in.readInt();
            }
            if (type == Boolean.TYPE) {
                return in.readBoolean();
            }
            if (type == Long.TYPE) {
                return in.readLong();
            }
            if (type == Short.TYPE) {
                return in.readShort();
            }
            if (type == Float.TYPE) {
                return Float.valueOf(in.readFloat());
            }
            if (type == Double.TYPE) {
                return in.readDouble();
            }
            if (type == Character.TYPE) {
                return Character.valueOf(in.readChar());
            }
            if (type == Byte.TYPE) {
                return in.readByte();
            }
            throw new AssertionError((Object)("Unrecognized primitive type: " + type));
        }
        return in.readObject();
    }

    public static boolean isPortBusy(int port, String bindAddr) throws UnknownHostException {
        InetAddress inetBindAddr = bindAddr != null ? InetAddress.getByName(bindAddr) : null;
        try {
            new ServerSocket(port, 0, inetBindAddr).close();
        }
        catch (IOException ex) {
            return true;
        }
        return false;
    }

    public static int getAnonymousPort() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    public static void writeShortArray(ObjectOutput out, short[] array) throws IOException {
        if (array == null) {
            out.writeInt(-1);
        } else {
            int length = array.length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                out.writeShort(array[i]);
            }
        }
    }

    public static short[] readShortArray(ObjectInput in) throws IOException {
        short[] array = null;
        int length = in.readInt();
        if (length >= 0) {
            array = new short[length];
            for (int i = 0; i < length; ++i) {
                array[i] = in.readShort();
            }
        }
        return array;
    }

    public static void writeIntegerArray(ObjectOutput out, int[] array) throws IOException {
        if (array == null) {
            out.writeInt(-1);
        } else {
            int length = array.length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                out.writeInt(array[i]);
            }
        }
    }

    public static int[] readIntegerArray(ObjectInput in) throws IOException {
        int[] array = null;
        int length = in.readInt();
        if (length >= 0) {
            array = new int[length];
            for (int i = 0; i < length; ++i) {
                array[i] = in.readInt();
            }
        }
        return array;
    }

    public static void writeLongArray(ObjectOutput out, long[] array) throws IOException {
        if (array == null) {
            out.writeInt(-1);
        } else {
            int length = array.length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                out.writeLong(array[i]);
            }
        }
    }

    public static long[] readLongArray(ObjectInput in) throws IOException {
        long[] array = null;
        int length = in.readInt();
        if (length >= 0) {
            array = new long[length];
            for (int i = 0; i < length; ++i) {
                array[i] = in.readLong();
            }
        }
        return array;
    }

    public static void writeByteArray(ObjectOutput out, byte[] array) throws IOException {
        if (array == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(array.length);
            out.write(array);
        }
    }

    public static byte[] readByteArray(ObjectInput in) throws IOException {
        int length = in.readInt();
        if (length == -1) {
            return null;
        }
        byte[] array = new byte[length];
        in.readFully(array);
        return array;
    }

    public static void writeBooleanArray(ObjectOutput out, boolean[] array) throws IOException {
        if (array == null) {
            out.writeInt(-1);
        } else {
            int length = array.length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                out.writeBoolean(array[i]);
            }
        }
    }

    public static boolean[] readBooleanArray(ObjectInput in) throws IOException {
        boolean[] array = null;
        int length = in.readInt();
        if (length >= 0) {
            array = new boolean[length];
            for (int i = 0; i < length; ++i) {
                array[i] = in.readBoolean();
            }
        }
        return array;
    }

    public static void writeRepetitiveString(ObjectOutput out, String s) throws IOException {
        if (out instanceof MarshalOutputStream) {
            ((MarshalOutputStream)out).writeRepetitiveObject(s);
        } else {
            IOUtils.writeString(out, s);
        }
    }

    public static String readRepetitiveString(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in instanceof MarshalInputStream) {
            return (String)((MarshalInputStream)in).readRepetitiveObject();
        }
        return IOUtils.readString(in);
    }

    public static void writeString(ObjectOutput out, String s) throws IOException {
        BootIOUtils.writeString((ObjectOutput)out, (String)s);
    }

    public static String readString(ObjectInput in) throws IOException, ClassNotFoundException {
        return BootIOUtils.readString((ObjectInput)in);
    }

    public static void writeStringArray(ObjectOutput out, String[] array) throws IOException {
        BootIOUtils.writeStringArray((ObjectOutput)out, (String[])array);
    }

    public static String[] readStringArray(ObjectInput in) throws IOException, ClassNotFoundException {
        String[] array = null;
        int length = in.readInt();
        if (length >= 0) {
            array = new String[length];
            for (int i = 0; i < length; ++i) {
                array[i] = IOUtils.readString(in);
            }
        }
        return array;
    }

    public static void writeStringSet(ObjectOutput out, Set<String> set) throws IOException {
        if (set == null) {
            out.writeInt(-1);
        } else {
            int length = set.size();
            out.writeInt(length);
            for (String str : set) {
                IOUtils.writeString(out, str);
            }
        }
    }

    public static Set<String> readStringSet(ObjectInput in) throws IOException, ClassNotFoundException {
        HashSet<String> set = null;
        int length = in.readInt();
        if (length >= 0) {
            set = new HashSet<String>();
            for (int i = 0; i < length; ++i) {
                set.add(IOUtils.readString(in));
            }
        }
        return set;
    }

    public static void writeRepetitiveStringArray(ObjectOutput out, String[] array) throws IOException {
        if (array == null) {
            out.writeInt(-1);
        } else {
            int length = array.length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                IOUtils.writeRepetitiveString(out, array[i]);
            }
        }
    }

    public static String[] readRepetitiveStringArray(ObjectInput in) throws IOException, ClassNotFoundException {
        String[] array = null;
        int length = in.readInt();
        if (length >= 0) {
            array = new String[length];
            for (int i = 0; i < length; ++i) {
                array[i] = IOUtils.readRepetitiveString(in);
            }
        }
        return array;
    }

    public static void writeList(ObjectOutput out, List list) throws IOException {
        if (list == null) {
            out.writeInt(-1);
        } else {
            int length = list.size();
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                IOUtils.writeObject(out, list.get(i));
            }
        }
    }

    public static List readList(ObjectInput in) throws IOException, ClassNotFoundException {
        ArrayList list = null;
        int length = in.readInt();
        if (length >= 0) {
            list = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                list.add(IOUtils.readObject(in));
            }
        }
        return list;
    }

    public static void writeListString(ObjectOutput out, List<String> list) throws IOException {
        if (list == null) {
            out.writeInt(-1);
        } else {
            int length = list.size();
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                IOUtils.writeString(out, list.get(i));
            }
        }
    }

    public static List<String> readListString(ObjectInput in) throws IOException, ClassNotFoundException {
        ArrayList<String> list = null;
        int length = in.readInt();
        if (length >= 0) {
            list = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                list.add(IOUtils.readString(in));
            }
        }
        return list;
    }

    public static void writeMapStringString(ObjectOutput out, Map<String, String> map) throws IOException {
        BootIOUtils.writeMapStringString((ObjectOutput)out, map);
    }

    public static Map<String, String> readMapStringString(ObjectInput in) throws IOException, ClassNotFoundException {
        return BootIOUtils.readMapStringString((ObjectInput)in);
    }

    public static void writeMapStringObject(ObjectOutput out, Map<String, Object> map) throws IOException {
        if (map == null) {
            out.writeInt(-1);
        } else {
            int length = map.size();
            out.writeInt(length);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                IOUtils.writeString(out, entry.getKey());
                IOUtils.writeObject(out, entry.getValue());
            }
        }
    }

    public static Map<String, Object> readMapStringObject(ObjectInput in) throws IOException, ClassNotFoundException {
        HashMap map = null;
        int length = in.readInt();
        if (length >= 0) {
            map = new HashMap(length);
            for (int i = 0; i < length; ++i) {
                String key = IOUtils.readString(in);
                Object value = IOUtils.readObject(in);
                map.put(key, value);
            }
        }
        return map;
    }

    public static <T> void writeMapRepetitiveKeys(ObjectOutput out, Map<String, T> map) throws IOException {
        if (map == null) {
            out.writeInt(-1);
        } else {
            int length = map.size();
            out.writeInt(length);
            for (Map.Entry<String, T> entry : map.entrySet()) {
                IOUtils.writeRepetitiveString(out, entry.getKey());
                IOUtils.writeObject(out, entry.getValue());
            }
        }
    }

    public static <T> Map<String, T> readMapRepetitiveKeys(ObjectInput in) throws IOException, ClassNotFoundException {
        HashMap<String, T> map = null;
        int length = in.readInt();
        if (length >= 0) {
            map = new HashMap<String, T>(length);
            for (int i = 0; i < length; ++i) {
                String key = IOUtils.readRepetitiveString(in);
                T value = IOUtils.readObject(in);
                map.put(key, value);
            }
        }
        return map;
    }

    public static void writeRepetitiveObject(ObjectOutput out, Object obj) throws IOException {
        if (out instanceof MarshalOutputStream) {
            ((MarshalOutputStream)out).writeRepetitiveObject(obj);
        } else {
            IOUtils.writeObject(out, obj);
        }
    }

    public static void writeObject(ObjectOutput out, Object obj) throws IOException {
        Class<?> type = obj != null ? obj.getClass() : null;
        IClassSerializer<?> serializer = _typeCache.get(type);
        if (serializer == null) {
            serializer = _defaultSerializer;
        }
        out.writeByte(serializer.getCode());
        serializer.write(out, obj);
    }

    public static <T> T readRepetitiveObject(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in instanceof MarshalInputStream) {
            return (T)((MarshalInputStream)in).readRepetitiveObject();
        }
        return IOUtils.readObject(in);
    }

    public static <T> T readObject(ObjectInput in) throws IOException, ClassNotFoundException {
        byte code = in.readByte();
        IClassSerializer<?> serializer = _codeCache.get(code);
        if (serializer == null) {
            throw new ClassNotFoundException("Unknown class code: " + code);
        }
        Object result = serializer.read(in);
        return (T)result;
    }

    public static void writeObjectArray(ObjectOutput out, Object[] array) throws IOException {
        if (array == null) {
            out.writeInt(-1);
        } else {
            int i;
            int length = array.length;
            out.writeInt(length);
            try {
                for (i = 0; i < length; ++i) {
                    IOUtils.writeObject(out, array[i]);
                }
            }
            catch (IOException e) {
                throw new IOArrayException(i, "Failed to serialize item #" + i, e);
            }
        }
    }

    public static Object[] readObjectArray(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int length = in.readInt();
        if (length < 0) {
            return null;
        }
        Object[] array = new Object[length];
        try {
            for (i = 0; i < length; ++i) {
                array[i] = IOUtils.readObject(in);
            }
        }
        catch (IOException e) {
            throw new IOArrayException(i, "Failed to deserialize item #" + i, e);
        }
        return array;
    }

    public static Throwable[] readThrowableArray(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        if (length < 0) {
            return null;
        }
        Throwable[] array = new Throwable[length];
        for (int i = 0; i < length; ++i) {
            array[i] = (Throwable)IOUtils.readObject(in);
        }
        return array;
    }

    public static Exception[] readExceptionArray(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        if (length < 0) {
            return null;
        }
        Exception[] array = new Exception[length];
        for (int i = 0; i < length; ++i) {
            array[i] = (Exception)IOUtils.readObject(in);
        }
        return array;
    }

    public static IEntryPacket[] readEntryPacketArray(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        if (length < 0) {
            return null;
        }
        IEntryPacket[] array = new IEntryPacket[length];
        for (int i = 0; i < length; ++i) {
            array[i] = (IEntryPacket)IOUtils.readObject(in);
        }
        return array;
    }

    public static ITemplatePacket[] readTemplatePacketArray(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        if (length < 0) {
            return null;
        }
        ITemplatePacket[] array = new ITemplatePacket[length];
        for (int i = 0; i < length; ++i) {
            array[i] = (ITemplatePacket)IOUtils.readObject(in);
        }
        return array;
    }

    public static void writeObjectArrayCompressed(ObjectOutput out, Object[] array) throws IOException {
        int length = array.length;
        int numNonNullFields = 0;
        for (int i = 0; i < length; ++i) {
            if (array[i] == null) continue;
            ++numNonNullFields;
        }
        boolean isCompressed = numNonNullFields < length / 2;
        out.writeBoolean(isCompressed);
        if (isCompressed) {
            int i;
            out.writeInt(length);
            out.writeInt(numNonNullFields);
            try {
                for (i = 0; i < length; ++i) {
                    if (array[i] == null) continue;
                    out.writeInt(i);
                    IOUtils.writeObject(out, array[i]);
                }
            }
            catch (IOException e) {
                throw new IOArrayException(i, "Failed to serialize item #" + i, e);
            }
        } else {
            IOUtils.writeObjectArray(out, array);
        }
    }

    public static Object[] readObjectArrayCompressed(ObjectInput in) throws IOException, ClassNotFoundException {
        Object[] array;
        boolean isCompressed = in.readBoolean();
        if (isCompressed) {
            int i;
            int length = in.readInt();
            array = new Object[length];
            int numNonNullFields = in.readInt();
            try {
                for (i = 0; i < numNonNullFields; ++i) {
                    int pos = in.readInt();
                    array[pos] = IOUtils.readObject(in);
                }
            }
            catch (IOException e) {
                throw new IOArrayException(i, "Failed to deserialize item #" + i, e);
            }
        } else {
            array = IOUtils.readObjectArray(in);
        }
        return array;
    }

    public static void writeSwapExternalizableObject(ObjectOutput out, ISwapExternalizable swapExternalizable) throws IOException {
        Class<?> clazz = swapExternalizable.getClass();
        int code = IOUtils.getCode(clazz);
        out.writeInt(code);
        swapExternalizable.writeToSwap(out);
        out.flush();
    }

    public static <T extends ISwapExternalizable> T readSwapExternalizableObject(ObjectInput in) throws IOException, ClassNotFoundException {
        int classCode = in.readInt();
        Class<?> clazz = IOUtils.getClass(classCode);
        try {
            ISwapExternalizable newInstance = (ISwapExternalizable)clazz.newInstance();
            newInstance.readFromSwap(in);
            return (T)newInstance;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static void writeNullableSwapExternalizableObject(ObjectOutput out, ISwapExternalizable swapExternalizable) throws IOException {
        out.writeBoolean(swapExternalizable != null);
        if (swapExternalizable != null) {
            IOUtils.writeSwapExternalizableObject(out, swapExternalizable);
        }
    }

    public static <T extends ISwapExternalizable> T readNullableSwapExternalizableObject(ObjectInput in) throws IOException, ClassNotFoundException {
        if (!in.readBoolean()) {
            return null;
        }
        return IOUtils.readSwapExternalizableObject(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWithCachedStubs(ObjectOutput out, Object obj) throws IOException {
        LRMIInvocationContext currentContext = LRMIInvocationContext.getCurrentContext();
        boolean previousStubCacheState = currentContext.isUseStubCache();
        currentContext.setUseStubCache(true);
        try {
            IOUtils.writeObject(out, obj);
        }
        finally {
            currentContext.setUseStubCache(previousStubCacheState);
        }
    }

    public static <T> T readWithCachedStubs(ObjectInput in) throws IOException, ClassNotFoundException {
        return IOUtils.readObject(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getClass(int classCode) {
        Class<?> clazz = _codeToClass.get(classCode);
        if (clazz != null) {
            return clazz;
        }
        ObjectIntegerMap<Class<?>> objectIntegerMap = _classToCode;
        synchronized (objectIntegerMap) {
            return _codeToClass.get(classCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCode(Class<?> clazz) {
        if (_classToCode.containsKey(clazz)) {
            return _classToCode.get(clazz);
        }
        ObjectIntegerMap<Class<?>> objectIntegerMap = _classToCode;
        synchronized (objectIntegerMap) {
            if (_classToCode.containsKey(clazz)) {
                return _classToCode.get(clazz);
            }
            int associatedKey = _swapExtenKey++;
            _classToCode.put(clazz, associatedKey);
            _codeToClass.put(associatedKey, clazz);
            return associatedKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(ObjectInput in, SupportCodeChangeAnnotationContainer supportCodeChangeAnnotationContainer, boolean useIOUtilsReadObject) throws ClassNotFoundException, IOException {
        if (supportCodeChangeAnnotationContainer == null) {
            return IOUtils.readObject(in, useIOUtilsReadObject);
        }
        ClassLoader current = ClassLoaderHelper.getContextClassLoader();
        try {
            ClassLoader codeChangeClassLoader = null;
            codeChangeClassLoader = current instanceof ServiceClassLoader ? ((ServiceClassLoader)current).getCodeChangeClassLoader(supportCodeChangeAnnotationContainer) : CodeChangeClassLoadersManager.getInstance().getCodeChangeClassLoader(supportCodeChangeAnnotationContainer);
            ClassLoaderHelper.setContextClassLoader(codeChangeClassLoader, true);
            Object object = IOUtils.readObject(in, useIOUtilsReadObject);
            return object;
        }
        finally {
            ClassLoaderHelper.setContextClassLoader(current, true);
        }
    }

    private static Object readObject(ObjectInput in, boolean useIOUtilsReadObject) throws IOException, ClassNotFoundException {
        if (useIOUtilsReadObject) {
            return IOUtils.readObject(in);
        }
        return in.readObject();
    }

    public static void serializeSupportCodeChangeCollection(ObjectOutput out, Collection collection) throws IOException {
        out.writeInt(collection.size());
        for (Object object : collection) {
            SupportCodeChangeAnnotationContainer supportCodeChangeAnnotationContainer = CodeChangeUtilities.createContainerFromSupportCodeAnnotationIfNeeded(object);
            out.writeObject(supportCodeChangeAnnotationContainer);
            out.writeObject(object);
        }
    }

    public static void deserializeSupportCodeChangeCollection(ObjectInput in, Collection collection) throws IOException, ClassNotFoundException {
        int collectionSize = in.readInt();
        for (int i = 0; i < collectionSize; ++i) {
            SupportCodeChangeAnnotationContainer codeChangeAnnotationContainer = (SupportCodeChangeAnnotationContainer)in.readObject();
            Object object = IOUtils.readObject(in, codeChangeAnnotationContainer, false);
            collection.add(object);
        }
    }

    public static void writeShort(ObjectOutput out, short value) throws IOException {
        IOUtils.writeInt(out, value);
    }

    public static void writeInt(ObjectOutput out, int value) throws IOException {
        int b = 0;
        if (value < 0) {
            b = 64;
            value ^= 0xFFFFFFFF;
        }
        b = (byte)(b | (byte)(value & 0x3F));
        value >>= 6;
        while (value != 0) {
            b = (byte)(b | 0x80);
            out.writeByte(b);
            b = (byte)(value & 0x7F);
            value >>= 7;
        }
        out.writeByte(b);
    }

    public static void writeLong(ObjectOutput out, long value) throws IOException {
        int b = 0;
        if (value < 0L) {
            b = 64;
            value ^= 0xFFFFFFFFFFFFFFFFL;
        }
        b = (byte)(b | (byte)((int)value & 0x3F));
        value >>= 6;
        while (value != 0L) {
            b = (byte)(b | 0x80);
            out.writeByte(b);
            b = (byte)((int)value & 0x7F);
            value >>= 7;
        }
        out.writeByte(b);
    }

    public static short readShort(ObjectInput in) throws IOException {
        return (short)IOUtils.readInt(in);
    }

    public static int readInt(ObjectInput in) throws IOException {
        boolean fNeg;
        byte b = in.readByte();
        int value = b & 0x3F;
        int cBits = 6;
        boolean bl = fNeg = (b & 0x40) != 0;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            value |= (b & 0x7F) << cBits;
            cBits += 7;
        }
        if (fNeg) {
            value ^= 0xFFFFFFFF;
        }
        return value;
    }

    public static long readLong(ObjectInput in) throws IOException {
        boolean fNeg;
        byte b = in.readByte();
        long l = b & 0x3F;
        int cBits = 6;
        boolean bl = fNeg = (b & 0x40) != 0;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            l |= (long)(b & 0x7F) << cBits;
            cBits += 7;
        }
        if (fNeg) {
            l ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }

    static {
        _classToCode = CollectionsFactory.getInstance().createObjectIntegerMap();
        _codeToClass = CollectionsFactory.getInstance().createIntegerObjectMap();
        _swapExtenKey = 0;
        _defaultSerializer = new ObjectClassSerializer();
        _typeCache = new HashMap();
        _codeCache = new HashMap();
        _codeCache.put(_defaultSerializer.getCode(), _defaultSerializer);
        IOUtils.register(null, new NullClassSerializer());
        IOUtils.register(Byte.class, new ByteClassSerializer());
        IOUtils.register(Short.class, new ShortClassSerializer());
        IOUtils.register(Integer.class, new IntegerClassSerializer());
        IOUtils.register(Long.class, new LongClassSerializer());
        IOUtils.register(Float.class, new FloatClassSerializer());
        IOUtils.register(Double.class, new DoubleClassSerializer());
        IOUtils.register(Boolean.class, new BooleanClassSerializer());
        IOUtils.register(Character.class, new CharacterClassSerializer());
        IOUtils.register(String.class, new StringClassSerializer());
        IOUtils.register(byte[].class, new ByteArrayClassSerializer());
    }

    public static final class NoHeaderObjectInputStream
    extends ObjectInputStream {
        public NoHeaderObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected void readStreamHeader() throws IOException, StreamCorruptedException {
        }
    }

    public static final class NoHeaderObjectOutputStream
    extends ObjectOutputStream {
        public NoHeaderObjectOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void writeStreamHeader() throws IOException {
            this.writeByte(121);
        }
    }
}

