/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

@InternalApi
public class MarshObject
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int NULL_HASHCODE = 13;
    private byte[] _bytes;
    private int _hashCode;

    public MarshObject() {
    }

    public MarshObject(byte[] bytes) {
        this._bytes = bytes;
        this._hashCode = bytes != null ? MarshObject.computeHash(bytes) : 13;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MarshObject) {
            MarshObject mo = (MarshObject)obj;
            return Arrays.equals(this._bytes, mo._bytes);
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    private static int computeHash(byte[] bytes) {
        int h = 0;
        for (byte b : bytes) {
            h = 31 * h + b;
        }
        return h;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeByteArray(out, this._bytes);
        if (this._bytes != null) {
            out.writeInt(this._hashCode);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._bytes = IOUtils.readByteArray(in);
        this._hashCode = this._bytes != null ? in.readInt() : 13;
    }

    public String toString() {
        return "MarshObject [" + this._bytes.length + " bytes]";
    }
}

