/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.GSByteArrayInputStream;
import com.gigaspaces.internal.io.GSByteArrayOutputStream;
import com.gigaspaces.internal.io.ISmartLengthBasedCacheCallback;
import com.gigaspaces.internal.io.MarshObject;
import com.gigaspaces.internal.io.MarshObjectConvertorResource;
import com.gigaspaces.internal.io.SmartByteArrayCache;
import com.gigaspaces.internal.io.SmartLengthBasedCache;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResourceFactory;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResourcePool;
import com.j_spaces.kernel.pool.IResourceFactory;
import com.j_spaces.kernel.pool.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class MarshObjectConvertor
extends Resource
implements MarshObjectConvertorResource {
    private GSByteArrayOutputStream _bao;
    private final SmartByteArrayCache _byteArrayCache;
    private ObjectOutputStream _oo;
    private GSByteArrayInputStream _bai;
    private ObjectInputStream _oi;
    private static MarshObjectConvertorFactory _factory = null;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private static final byte[] DUMMY_BUFFER = new byte[0];
    private static final byte[] RESET_BUFFER = new byte[]{121, 112};

    private static SmartByteArrayCache createSerializationByteArrayCache(ISmartLengthBasedCacheCallback cacheCallback) {
        int maxBufferSize = Integer.getInteger("com.gs.client.storage-type-serialization.cache.buffer-size", 0x4000000);
        double expungeRatio = Double.parseDouble(System.getProperty("com.gs.client.storage-type-serialization.cache.buffer-expunge-ratio", String.valueOf(0.5)));
        int expungeCount = Integer.getInteger("com.gs.client.storage-type-serialization.cache.buffer-expunge-times-threshold", 20);
        return new SmartByteArrayCache(maxBufferSize, expungeRatio, expungeCount, 1024, cacheCallback);
    }

    public MarshObjectConvertor() {
        this(null);
    }

    public MarshObjectConvertor(ISmartLengthBasedCacheCallback cacheCallback) {
        block5: {
            this._byteArrayCache = MarshObjectConvertor.createSerializationByteArrayCache(cacheCallback);
            try {
                this._bao = new GSByteArrayOutputStream();
                this._oo = this.getObjectOutputStream(this._bao);
                this._bai = new GSByteArrayInputStream(new byte[0]);
                try {
                    this.getObject(this.getMarshObjectInternal("", true));
                }
                catch (ClassNotFoundException e) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            catch (IOException e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block5;
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    @Override
    public MarshObject getMarshObject(Object o) throws IOException {
        return this.getMarshObjectInternal(o, false);
    }

    private MarshObject getMarshObjectInternal(Object o, boolean init) throws IOException {
        byte[] bc;
        if (init) {
            bc = this.serializeToByteArray(o);
        } else {
            this._bao.setBuffer((byte[])this._byteArrayCache.get());
            this._oo.reset();
            bc = this.serializeToByteArray(o);
            this._byteArrayCache.notifyUsedSize(bc.length);
            this._bao.setBuffer(DUMMY_BUFFER);
            this._oo.reset();
        }
        MarshObject marObj = new MarshObject(bc);
        return marObj;
    }

    protected byte[] serializeToByteArray(Object o) throws IOException {
        this._oo.writeObject(o);
        this._oo.flush();
        return this._bao.toByteArray();
    }

    @Override
    public Object getObject(MarshObject marsh) throws IOException, ClassNotFoundException {
        return this.getObject(marsh.getBytes());
    }

    public Object getObject(byte[] bytes) throws IOException, ClassNotFoundException {
        this._bai.setBuffer(bytes);
        if (this._oi == null) {
            this._oi = this.getObjectInputStream(this._bai);
        }
        Object object = this._oi.readObject();
        this._bai.setBuffer(RESET_BUFFER);
        this._oi.readObject();
        return object;
    }

    @Override
    public void clear() {
    }

    protected ObjectInputStream getObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStream(is);
    }

    protected ObjectOutputStream getObjectOutputStream(OutputStream os) throws IOException {
        return new ObjectOutputStream(os);
    }

    public static IResourceFactory<MarshObjectConvertor> getFactory() {
        if (_factory == null) {
            _factory = new MarshObjectConvertorFactory();
        }
        return _factory;
    }

    @Override
    public long getUsedMemory() {
        return this._byteArrayCache.getLength();
    }

    protected static class MarshObjectConvertorFactory
    implements IMemoryAwareResourceFactory<MarshObjectConvertor> {
        protected MarshObjectConvertorFactory() {
        }

        @Override
        public MarshObjectConvertor allocate() {
            return new MarshObjectConvertor();
        }

        @Override
        public MarshObjectConvertor allocate(IMemoryAwareResourcePool resourcePool) {
            return new MarshObjectConvertor(SmartLengthBasedCache.toCacheCallback(resourcePool));
        }
    }
}

