/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.classloader.ClassLoaderCache;
import com.gigaspaces.internal.classloader.IClassLoaderCacheStateListener;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.IntegerObjectMap;
import com.gigaspaces.internal.io.AnnotatedObjectInputStream;
import com.gigaspaces.internal.io.MarshalContextClearedException;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.j_spaces.kernel.ClassLoaderHelper;
import com.j_spaces.kernel.ISafeArray;
import com.j_spaces.kernel.SafeArray;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class MarshalInputStream
extends AnnotatedObjectInputStream {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi.marshal");
    private static final int CODE_DISABLED = -1;
    private static final int CODE_NULL = 0;
    static final Map<String, Class<?>> _specialClasses = new HashMap();
    private final Context _context;

    public MarshalInputStream(InputStream in) throws IOException {
        this(in, new Context());
    }

    public MarshalInputStream(InputStream in, Context context) throws IOException {
        super(in);
        this._context = context;
    }

    public static Context createContext() {
        return new Context();
    }

    public Object readRepetitiveObject() throws IOException, ClassNotFoundException {
        int code = this.readInt();
        if (code == 0) {
            return null;
        }
        if (code == -1) {
            return this.readObject();
        }
        Object value = this._context.getRepetitiveObjectsCache().get(code);
        if (value != null) {
            return value;
        }
        value = this.readObject();
        if (value instanceof String) {
            value = ((String)value).intern();
        }
        this._context.getRepetitiveObjectsCache().put(code, value);
        return value;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        Class resolvedClass;
        block4: {
            resolvedClass = this._context.getResolvedClass(classDesc);
            if (resolvedClass != null) {
                return resolvedClass;
            }
            try {
                boolean containsAnnotation = this._context.containsAnnotation(classDesc);
                String annotation = null;
                if (containsAnnotation) {
                    annotation = this._context.getAnnotation(classDesc);
                }
                resolvedClass = super.resolveClass(classDesc, !containsAnnotation, annotation);
            }
            catch (ClassNotFoundException e) {
                String name = classDesc.getName();
                resolvedClass = _specialClasses.get(name);
                if (resolvedClass != null) break block4;
                throw e;
            }
        }
        this._context.putResolvedClass(classDesc, resolvedClass);
        return resolvedClass;
    }

    @Override
    protected String readAnnotation(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String annotation = super.readAnnotation(desc);
        this._context.putAnnotation(desc, annotation);
        return annotation;
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaceNames) throws IOException, ClassNotFoundException {
        NamesWrapper names = new NamesWrapper(interfaceNames);
        Class<?> cl = this._context.getClassFromAnnotateInterfaceNameMap(names);
        if (cl != null) {
            return cl;
        }
        cl = super.resolveProxyClass(interfaceNames);
        if (cl != null) {
            this._context.putAnnotateInterfaceNamesMap(names, cl);
        }
        return cl;
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass cl = null;
        int index = this.readInt();
        if (index != -1) {
            cl = this._context.getObjectStreamClass(index);
        }
        if (cl == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                Long classLoaderKey = ClassLoaderCache.getCache().getClassLoaderKey(ClassLoaderHelper.getContextClassLoader());
                MarshalInputStream.logFinest("Received new incoming ObjectStreamClass with key " + index + ", context class loader key " + classLoaderKey + ", reading it from stream");
            }
            cl = super.readClassDescriptor();
            if (index != -1) {
                this._context.addObjectStreamClass(index, cl);
            }
        }
        return cl;
    }

    @Override
    protected void readStreamHeader() throws IOException {
    }

    public void closeContext() {
        this._context.close();
    }

    public void resetContext() {
        this._context.reset();
    }

    private static void logFinest(String log) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, log + ", context=" + LRMIInvocationContext.getContextMethodLongDisplayString());
        }
    }

    static {
        _specialClasses.put("boolean", Boolean.TYPE);
        _specialClasses.put("byte", Byte.TYPE);
        _specialClasses.put("char", Character.TYPE);
        _specialClasses.put("short", Short.TYPE);
        _specialClasses.put("int", Integer.TYPE);
        _specialClasses.put("long", Long.TYPE);
        _specialClasses.put("float", Float.TYPE);
        _specialClasses.put("double", Double.TYPE);
        _specialClasses.put("void", Void.TYPE);
    }

    static final class NamesWrapper {
        private final String[] _interfaceNames;
        private final int _hashCode;

        public NamesWrapper(String[] interfaceNames) {
            this._interfaceNames = interfaceNames;
            this._hashCode = this._interfaceNames.length > 0 ? this._interfaceNames[0].hashCode() : 4325349;
        }

        public boolean equals(Object wrapper) {
            return Arrays.equals(this._interfaceNames, ((NamesWrapper)wrapper)._interfaceNames);
        }

        public int hashCode() {
            return this._hashCode;
        }

        public String toString() {
            return Arrays.toString(this._interfaceNames);
        }
    }

    public static class Context
    implements IClassLoaderCacheStateListener {
        private final HashMap<Long, ClassLoaderContext> _classLoaderContextMap = new HashMap();
        private final ISafeArray<ObjectStreamClass> classMap = new SafeArray<ObjectStreamClass>();
        private final HashMap<ObjectStreamClass, String> annotationMap = new HashMap();
        private static final ClassLoaderContext REMOVED_CONTEXT_MARKER = new ClassLoaderContext(-2L);
        private static final long NULL_CL_MARKER = -1L;
        private final IntegerObjectMap<Object> _repetitiveObjectsCache = CollectionsFactory.getInstance().createIntegerObjectMap();

        public IntegerObjectMap<Object> getRepetitiveObjectsCache() {
            return this._repetitiveObjectsCache;
        }

        public synchronized void addObjectStreamClass(int index, ObjectStreamClass cl) {
            this.classMap.add(index, cl);
            if (_logger.isLoggable(Level.FINEST)) {
                MarshalInputStream.logFinest("Adding new ObjectStreamClass to incoming context [" + cl.getName() + "] with specified key " + index + ", context class loader key " + ClassLoaderCache.getCache().getClassLoaderKey(ClassLoaderHelper.getContextClassLoader()));
            }
        }

        public synchronized String getAnnotation(ObjectStreamClass classDesc) {
            return this.annotationMap.get(classDesc);
        }

        public synchronized boolean containsAnnotation(ObjectStreamClass classDesc) {
            return this.annotationMap.containsKey(classDesc);
        }

        public synchronized void putAnnotation(ObjectStreamClass desc, String annotation) {
            this.annotationMap.put(desc, annotation);
        }

        public synchronized ObjectStreamClass getObjectStreamClass(int index) {
            return this.classMap.get(index);
        }

        public synchronized void putAnnotateInterfaceNamesMap(NamesWrapper names, Class<?> cl) {
            ClassLoaderContext classLoaderContext = this.getClassLoaderContext(true);
            classLoaderContext.putAnnotateInterfaceNamesMap(names, cl);
            if (_logger.isLoggable(Level.FINEST)) {
                MarshalInputStream.logFinest("Adding new NamesWrapper to incoming context [" + names + "] for class " + cl.getName() + ", context class loader key " + classLoaderContext.getClassLoaderCacheKey());
            }
        }

        public synchronized Class<?> getClassFromAnnotateInterfaceNameMap(NamesWrapper names) {
            ClassLoaderContext classLoaderContext = this.getClassLoaderContext(false);
            if (classLoaderContext == null) {
                return null;
            }
            return classLoaderContext.getClassFromAnnotateInterfaceNameMap(names);
        }

        public synchronized void putResolvedClass(ObjectStreamClass classDesc, Class<?> cl) {
            ClassLoaderContext classLoaderContext = this.getClassLoaderContext(true);
            classLoaderContext.putResolvedClass(classDesc, cl);
            if (_logger.isLoggable(Level.FINEST)) {
                MarshalInputStream.logFinest("Adding new resolved class to incoming context [" + cl.getName() + "] for ObjectStreamClass " + classDesc.getName() + ", context class loader key " + classLoaderContext.getClassLoaderCacheKey());
            }
        }

        public synchronized Class<?> getResolvedClass(ObjectStreamClass classDesc) {
            ClassLoaderContext classLoaderContext = this.getClassLoaderContext(false);
            if (classLoaderContext == null) {
                return null;
            }
            return classLoaderContext.getResolvedClass(classDesc);
        }

        private ClassLoaderContext getClassLoaderContext(boolean createIfAbsent) {
            ClassLoader contextClassLoader = ClassLoaderHelper.getContextClassLoader();
            Long clKey = contextClassLoader == null ? -1L : ClassLoaderCache.getCache().putClassLoader(contextClassLoader);
            ClassLoaderContext classLoaderContext = this._classLoaderContextMap.get(clKey);
            if (classLoaderContext == REMOVED_CONTEXT_MARKER) {
                throw new MarshalContextClearedException("Service has been unloaded");
            }
            if (createIfAbsent && classLoaderContext == null) {
                boolean classLoaderPresent;
                classLoaderContext = new ClassLoaderContext(clKey);
                this._classLoaderContextMap.put(clKey, classLoaderContext);
                if (clKey != -1L && !(classLoaderPresent = ClassLoaderCache.getCache().registerClassLoaderStateListener(clKey, this))) {
                    this._classLoaderContextMap.remove(clKey);
                    throw new MarshalContextClearedException("Service has been unloaded");
                }
            }
            return classLoaderContext;
        }

        @Override
        public synchronized void onClassLoaderRemoved(Long classLoaderKey, boolean explicit) {
            if (_logger.isLoggable(Level.FINEST)) {
                MarshalInputStream.logFinest("Removed class loader [" + classLoaderKey + "] related context from marshal input stream, explicit=" + explicit);
            }
            this._classLoaderContextMap.put(classLoaderKey, REMOVED_CONTEXT_MARKER);
        }

        public synchronized void close() {
            if (_logger.isLoggable(Level.FINEST)) {
                MarshalInputStream.logFinest("Closing marshal input stream context");
            }
            for (Long clKey : this._classLoaderContextMap.keySet()) {
                this._classLoaderContextMap.put(clKey, REMOVED_CONTEXT_MARKER);
                ClassLoaderCache.getCache().removeClassLoaderStateListener(clKey, this);
            }
        }

        public synchronized void reset() {
            if (_logger.isLoggable(Level.FINEST)) {
                MarshalInputStream.logFinest("Resetting entire marshal input stream context");
            }
            for (Long clKey : this._classLoaderContextMap.keySet()) {
                this._classLoaderContextMap.put(clKey, REMOVED_CONTEXT_MARKER);
                ClassLoaderCache.getCache().removeClassLoaderStateListener(clKey, this);
            }
            this._classLoaderContextMap.clear();
            this.classMap.clear();
            this.annotationMap.clear();
            this._repetitiveObjectsCache.clear();
        }

        private static class ClassLoaderContext {
            private final HashMap<ObjectStreamClass, Class<?>> resolvedClassesMap = new HashMap();
            private final HashMap<NamesWrapper, Class<?>> annotateInterfaceNamesMap = new HashMap();
            private final Long clKey;

            public ClassLoaderContext(Long clKey) {
                this.clKey = clKey;
            }

            public Long getClassLoaderCacheKey() {
                return this.clKey;
            }

            public void putResolvedClass(ObjectStreamClass classDesc, Class<?> cl) {
                this.resolvedClassesMap.put(classDesc, cl);
            }

            public Class<?> getResolvedClass(ObjectStreamClass classDesc) {
                return this.resolvedClassesMap.get(classDesc);
            }

            public Class<?> getClassFromAnnotateInterfaceNameMap(NamesWrapper names) {
                return this.annotateInterfaceNamesMap.get(names);
            }

            public void putAnnotateInterfaceNamesMap(NamesWrapper names, Class<?> cl) {
                this.annotateInterfaceNamesMap.put(names, cl);
            }
        }
    }
}

