/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.classloader.ClassLoaderCache;
import com.gigaspaces.internal.classloader.IClassLoaderCacheStateListener;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ObjectIntegerMap;
import com.gigaspaces.internal.io.AnnotatedObjectOutputStream;
import com.gigaspaces.internal.io.MarshalContextClearedException;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class MarshalOutputStream
extends AnnotatedObjectOutputStream {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi.marshal");
    private static final int CODE_DISABLED = -1;
    private static final int CODE_NULL = 0;
    private final Context _context;
    private final boolean _optimize;
    private int _nextClassId = 1;

    public MarshalOutputStream(OutputStream out) throws IOException {
        this(out, true);
    }

    public MarshalOutputStream(OutputStream out, boolean optimize) throws IOException {
        super(out);
        this._optimize = optimize;
        this._context = new Context();
    }

    public void writeRepetitiveObject(Object obj) throws IOException {
        if (obj == null) {
            this.writeInt(0);
            return;
        }
        if (!this._optimize) {
            this.writeInt(-1);
            this.writeObject(obj);
            return;
        }
        int code = this._context.getRepetitiveObjectsCache().get(obj);
        if (code != 0) {
            this.writeInt(code);
            return;
        }
        code = this._context.getAndIncrementRepetitiveObjectCounter();
        this._context.getRepetitiveObjectsCache().put(obj, code);
        this.writeInt(code);
        this.writeObject(obj);
    }

    @Override
    protected void writeAnnotation(Class cl) throws IOException {
        if (this._context.containsAnnotation(cl)) {
            return;
        }
        this._context.addAnnotation(cl);
        super.writeAnnotation(cl);
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        int i = this._context.getObjectStreamClassKey(desc);
        boolean newClass = false;
        if (i == 0 || !this._optimize) {
            newClass = true;
            if (this._optimize) {
                i = this._nextClassId++;
                this._context.putObjectStreamClassKey(desc, i);
            } else {
                i = -1;
            }
        }
        this.writeInt(i);
        if (newClass) {
            super.writeClassDescriptor(desc);
        }
    }

    @Override
    protected void writeStreamHeader() throws IOException {
        this.writeByte(121);
    }

    public void closeContext() {
        this._context.close();
    }

    public void resetContext() {
        this._context.reset();
    }

    private static void logFinest(String log) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, log + ", context=" + LRMIInvocationContext.getContextMethodLongDisplayString());
        }
    }

    public static class Context
    implements IClassLoaderCacheStateListener {
        private final HashMap<Long, ClassLoaderContext> _classLoaderContextMap = new HashMap();
        private final ObjectIntegerMap<Object> _repetitiveObjectsCache = CollectionsFactory.getInstance().createObjectIntegerMap();
        private int _repetitiveObjectCounter = 1;
        private static final ClassLoaderContext REMOVED_CONTEXT_MARKER = new ClassLoaderContext(-2L);
        private static final long NULL_CL_MARKER = -1L;

        public synchronized void putObjectStreamClassKey(ObjectStreamClass desc, int key) {
            ClassLoaderContext classLoaderContext = this.getClassLoaderContext(true);
            classLoaderContext.putObjectStreamClass(desc, key);
            if (_logger.isLoggable(Level.FINEST)) {
                MarshalOutputStream.logFinest("Adding new ObjectStreamClass to outgoing context [" + desc.getName() + "] with specified key " + key + ", context class loader key " + classLoaderContext.getClassLoaderCacheKey());
            }
        }

        public synchronized void addAnnotation(Class<?> cl) {
            ClassLoaderContext classLoaderContext = this.getClassLoaderContext(true);
            classLoaderContext.addAnnotation(cl);
            if (_logger.isLoggable(Level.FINEST)) {
                MarshalOutputStream.logFinest("Adding new annotation to outgoing context [" + cl.getName() + "], context class loader key " + classLoaderContext.getClassLoaderCacheKey());
            }
        }

        public synchronized boolean containsAnnotation(Class<?> cl) {
            ClassLoaderContext classLoaderContext = this.getClassLoaderContext(false);
            if (classLoaderContext == null) {
                return false;
            }
            return classLoaderContext.containsAnnotation(cl);
        }

        public synchronized int getObjectStreamClassKey(ObjectStreamClass desc) {
            ClassLoaderContext classLoaderContext = this.getClassLoaderContext(false);
            if (classLoaderContext == null) {
                return 0;
            }
            return classLoaderContext.getObjectStreamClassKey(desc);
        }

        private ClassLoaderContext getClassLoaderContext(boolean createIfAbsent) {
            ClassLoader contextClassLoader = ClassLoaderHelper.getContextClassLoader();
            Long clKey = contextClassLoader == null ? -1L : ClassLoaderCache.getCache().putClassLoader(contextClassLoader);
            ClassLoaderContext classLoaderContext = this._classLoaderContextMap.get(clKey);
            if (classLoaderContext == REMOVED_CONTEXT_MARKER) {
                throw new MarshalContextClearedException("Service has been unloaded");
            }
            if (createIfAbsent && classLoaderContext == null) {
                boolean classLoaderPresent;
                classLoaderContext = new ClassLoaderContext(clKey);
                this._classLoaderContextMap.put(clKey, classLoaderContext);
                if (clKey != -1L && !(classLoaderPresent = ClassLoaderCache.getCache().registerClassLoaderStateListener(clKey, this))) {
                    this._classLoaderContextMap.remove(clKey);
                    throw new MarshalContextClearedException("Service has been unloaded");
                }
            }
            return classLoaderContext;
        }

        @Override
        public synchronized void onClassLoaderRemoved(Long classLoaderKey, boolean explicit) {
            if (_logger.isLoggable(Level.FINEST)) {
                MarshalOutputStream.logFinest("Removed class loader [" + classLoaderKey + "] related context from marshal output stream, explicit=" + explicit);
            }
            this._classLoaderContextMap.put(classLoaderKey, REMOVED_CONTEXT_MARKER);
        }

        public ObjectIntegerMap<Object> getRepetitiveObjectsCache() {
            return this._repetitiveObjectsCache;
        }

        public int getAndIncrementRepetitiveObjectCounter() {
            return this._repetitiveObjectCounter++;
        }

        public synchronized void close() {
            if (_logger.isLoggable(Level.FINEST)) {
                MarshalOutputStream.logFinest("Closing marshal output stream context");
            }
            for (Long clKey : this._classLoaderContextMap.keySet()) {
                this._classLoaderContextMap.put(clKey, REMOVED_CONTEXT_MARKER);
                ClassLoaderCache.getCache().removeClassLoaderStateListener(clKey, this);
            }
        }

        public synchronized void reset() {
            if (_logger.isLoggable(Level.FINEST)) {
                MarshalOutputStream.logFinest("Resetting entire marshal output stream context");
            }
            for (Long clKey : this._classLoaderContextMap.keySet()) {
                this._classLoaderContextMap.put(clKey, REMOVED_CONTEXT_MARKER);
                ClassLoaderCache.getCache().removeClassLoaderStateListener(clKey, this);
            }
            this._classLoaderContextMap.clear();
            this._repetitiveObjectsCache.clear();
            this._repetitiveObjectCounter = 1;
        }

        private static class ClassLoaderContext {
            private final ObjectIntegerMap<ObjectStreamClass> classMap = CollectionsFactory.getInstance().createObjectIntegerMap();
            private final HashSet<Class> annotateMap = new HashSet();
            private final Long clKey;

            public ClassLoaderContext(Long clKey) {
                this.clKey = clKey;
            }

            public void putObjectStreamClass(ObjectStreamClass oss, int key) {
                this.classMap.put(oss, key);
            }

            public Long getClassLoaderCacheKey() {
                return this.clKey;
            }

            public int getObjectStreamClassKey(ObjectStreamClass desc) {
                return this.classMap.get(desc);
            }

            public boolean containsAnnotation(Class<?> cl) {
                return this.annotateMap.contains(cl);
            }

            public void addAnnotation(Class<?> cl) {
                this.annotateMap.add(cl);
            }
        }
    }
}

