/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.internal.io.ISmartLengthBasedCacheCallback;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResourcePool;
import java.lang.ref.SoftReference;

public abstract class SmartLengthBasedCache<T> {
    private final int _maxCachedBufferLength;
    private final double _expungeRatio;
    private final int _expungeCount;
    private final int _defaultResourceLength;
    private final ISmartLengthBasedCacheCallback _callback;
    private SoftReference<T> _cachedResource;
    private int _usedTooSmallBuffer;

    public SmartLengthBasedCache(int maxCachedBufferLength, double expungeRatio, int expungeCount, int defaultResourceLength, ISmartLengthBasedCacheCallback callback) {
        this._maxCachedBufferLength = maxCachedBufferLength;
        this._expungeRatio = expungeRatio;
        this._expungeCount = expungeCount;
        this._defaultResourceLength = defaultResourceLength;
        this._callback = callback;
    }

    public T get(int length) {
        T resource = this.getCachedBuffer();
        if (resource == null || this.getResourceCapacity(resource) < length) {
            resource = this.createResource(length);
            this.tryCacheResource(resource);
        } else if (this.shouldExpunge(length, resource)) {
            this._usedTooSmallBuffer = 0;
            resource = this.createResource(length);
            this.tryCacheResource(resource);
        } else {
            this.prepareResource(resource, length);
        }
        return resource;
    }

    protected void tryCacheResource(T resource) {
        int resourceCapacity = this.getResourceCapacity(resource);
        if (resourceCapacity > this._maxCachedBufferLength) {
            return;
        }
        if (this._callback != null && !this._callback.mayCache(resourceCapacity)) {
            return;
        }
        this._cachedResource = new SoftReference<T>(resource);
    }

    protected abstract void prepareResource(T var1);

    protected abstract void prepareResource(T var1, int var2);

    protected abstract T createResource(int var1);

    protected abstract int getResourceCapacity(T var1);

    public long getLength() {
        T cachedBuffer = this.getCachedBuffer();
        if (cachedBuffer == null) {
            return 0L;
        }
        return this.getResourceCapacity(cachedBuffer);
    }

    private boolean shouldExpunge(int length, T resource) {
        return (double)length < (double)this.getResourceCapacity(resource) * this._expungeRatio && this._usedTooSmallBuffer++ >= this._expungeCount;
    }

    public T get() {
        T resource = this.getCachedBuffer();
        if (resource == null) {
            resource = this.createResource(this._defaultResourceLength);
            this.tryCacheResource(resource);
        } else {
            this.prepareResource(resource);
        }
        return resource;
    }

    public void set(T resource) {
        if (this.getResourceCapacity(resource) > this._maxCachedBufferLength) {
            return;
        }
        this.tryCacheResource(resource);
        this._usedTooSmallBuffer = 0;
    }

    public void notifyUsedSize(int usedSize) {
        T resource = this.getCachedBuffer();
        if (resource == null) {
            return;
        }
        if (this.shouldExpunge(usedSize, resource)) {
            this._cachedResource = null;
        }
    }

    private T getCachedBuffer() {
        SoftReference<T> cachedResource = this._cachedResource;
        return cachedResource == null ? null : (T)cachedResource.get();
    }

    public static ISmartLengthBasedCacheCallback toCacheCallback(final IMemoryAwareResourcePool resourcePool) {
        return new ISmartLengthBasedCacheCallback(){

            @Override
            public boolean mayCache(long length) {
                return !resourcePool.isLimitReached(length);
            }
        };
    }
}

