/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.WindowsRegistryException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;

@InternalApi
public class WindowsRegistryUtils {
    private static final int HKEY_CURRENT_USER = -2147483647;
    private static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final int KEY_QUERY_VALUE = 1;
    private static final int KEY_ENUMERATE_SUB_KEYS = 8;
    private static final int KEY_NOTIFY = 16;
    private static final int KEY_READ = 131097;
    private static final int ERROR_SUCCESS = 0;
    private static final int ERROR_FILE_NOT_FOUND = 2;
    private static final int ERROR_ACCESS_DENIED = 5;
    private static final int NATIVE_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static Preferences _prefsInstance = Preferences.userRoot();
    private static final Method _openKeyMethod;
    private static final Method _closeKeyMethod;
    private static final Method _queryValueMethod;

    private static Integer openKey(Integer baseKey, String keyPath) {
        return WindowsRegistryUtils.openKey(baseKey, keyPath, 131097);
    }

    private static Integer openKey(Integer baseKey, String keyPath, int securityToken) {
        int[] result = (int[])WindowsRegistryUtils.invokeRegistryMethod(_openKeyMethod, baseKey, WindowsRegistryUtils.toByteArray(keyPath), securityToken);
        int errorCode = result[1];
        switch (errorCode) {
            case 0: {
                return result[0];
            }
            case 2: {
                return null;
            }
            case 5: {
                throw new WindowsRegistryException("Access denied. Path=" + keyPath + ", securityToken=" + securityToken);
            }
        }
        throw new WindowsRegistryException("Error. Code=" + errorCode + ", Path=" + keyPath + ", securityToken=" + securityToken);
    }

    private static void closeKey(Integer keyHandle) {
        if (keyHandle == null) {
            return;
        }
        Integer result = (Integer)WindowsRegistryUtils.invokeRegistryMethod(_closeKeyMethod, keyHandle);
        if (result != 0) {
            throw new WindowsRegistryException("Error. Code=" + result);
        }
    }

    private static String queryKeyValue(Integer keyHandle, String valueName) {
        byte[] rawValueName = WindowsRegistryUtils.toByteArray(valueName);
        byte[] rawResult = (byte[])WindowsRegistryUtils.invokeRegistryMethod(_queryValueMethod, keyHandle, rawValueName);
        if (rawResult == null) {
            return null;
        }
        String result = new String(rawResult, 0, rawResult.length - 1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readKeyValue(Integer keyHandle, String keyPath, String valueName) {
        Integer actualKeyHandle = null;
        try {
            actualKeyHandle = WindowsRegistryUtils.openKey(keyHandle, keyPath);
            if (actualKeyHandle == null) {
                String string = null;
                return string;
            }
            String string = WindowsRegistryUtils.queryKeyValue(actualKeyHandle, valueName);
            return string;
        }
        finally {
            WindowsRegistryUtils.closeKey(actualKeyHandle);
        }
    }

    public static String readKeyValueCurrentUser(String keyPath, String valueName) {
        return WindowsRegistryUtils.readKeyValue(-2147483647, keyPath, valueName);
    }

    public static String readKeyValueLocalMachine(String keyPath, String valueName) {
        return WindowsRegistryUtils.readKeyValue(-2147483646, keyPath, valueName);
    }

    private static <T> T invokeRegistryMethod(Method method, Object ... args) {
        try {
            return (T)method.invoke((Object)_prefsInstance, args);
        }
        catch (InvocationTargetException e) {
            throw new WindowsRegistryException("Error executing registry method " + method.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new WindowsRegistryException("Error executing registry method " + method.getName(), e);
        }
    }

    private static byte[] toByteArray(String str) {
        int length = str.length();
        byte[] result = new byte[length + 1];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[length] = 0;
        return result;
    }

    static {
        Class<?> prefsClass = _prefsInstance.getClass();
        try {
            _openKeyMethod = prefsClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            _openKeyMethod.setAccessible(true);
            _closeKeyMethod = prefsClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            _closeKeyMethod.setAccessible(true);
            _queryValueMethod = prefsClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            _queryValueMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new WindowsRegistryException("Error initializing Windows Registry utils.", e);
        }
    }
}

