/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.j_spaces.kernel.ResourceLoader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XmlUtils {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String VALID_SCHEMA_FILE = "clusterXML-Schema.xsd";
    private static DocumentBuilderFactory _docBuilderFactory;
    private static DocumentBuilderFactory _docBuilderFactoryValidated;
    private static final ErrorHandler _defaultErrorHandler;
    private static boolean _printJAXPDebug;

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return XmlUtils.getDocumentBuilder(false);
    }

    public static String nodeToString(Node node) throws TransformerException {
        StringWriter sw = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }

    public static DocumentBuilder getDocumentBuilder(boolean doValidation) throws ParserConfigurationException {
        DocumentBuilderFactory factory = XmlUtils.getDocumentBuilderFactory(doValidation);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setErrorHandler(_defaultErrorHandler);
        return documentBuilder;
    }

    private static synchronized DocumentBuilderFactory getDocumentBuilderFactory(boolean doValidation) {
        DocumentBuilderFactory factory;
        if (!doValidation) {
            if (_docBuilderFactory == null) {
                _docBuilderFactory = XmlUtils.createDocumentBuilderFactory(doValidation);
            }
            factory = _docBuilderFactory;
        } else {
            if (_docBuilderFactoryValidated == null) {
                _docBuilderFactoryValidated = XmlUtils.createDocumentBuilderFactory(doValidation);
            }
            factory = _docBuilderFactoryValidated;
        }
        return factory;
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory(boolean doValidation) {
        DocumentBuilderFactory factory;
        try {
            factory = DocumentBuilderFactory.newInstance();
        }
        catch (FactoryConfigurationError e) {
            System.err.println("Warning: Failed to use default DocumentBuilderFactory implementation. \nWill attempt to use org.apache.xerces.jaxp.DocumentBuilderFactoryImpl and org.apache.xerces.jaxp.SAXParserFactoryImpl: " + e.getMessage());
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
            factory = DocumentBuilderFactory.newInstance();
        }
        if (doValidation) {
            factory.setValidating(true);
            factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            factory.setAttribute(JAXP_SCHEMA_LOCATION, ResourceLoader.getResourceURL(VALID_SCHEMA_FILE).toString());
        }
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        return factory;
    }

    public static String getAttribute(Node node, String attributeName) {
        return XmlUtils.getAttribute(node, attributeName, null);
    }

    public static String getAttribute(Node node, String attributeName, String defaultValue) {
        Node attribute = node.getAttributes().getNamedItem(attributeName);
        return attribute != null ? attribute.getTextContent().trim() : defaultValue;
    }

    public static Boolean getAttributeBoolean(Node node, String attributeName) {
        String value = XmlUtils.getAttribute(node, attributeName, null);
        return value == null ? null : Boolean.valueOf(value);
    }

    public static boolean getAttributeBoolean(Node node, String attributeName, boolean defaultValue) {
        String value = XmlUtils.getAttribute(node, attributeName, null);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public static Integer getAttributeInteger(Node node, String attributeName) {
        String value = XmlUtils.getAttribute(node, attributeName, null);
        return value == null ? null : Integer.valueOf(value);
    }

    public static int getAttributeInteger(Node node, String attributeName, int defaultValue) {
        String value = XmlUtils.getAttribute(node, attributeName, null);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public static <T extends Enum<T>> T getAttributeEnum(Node node, String attributeName, Class<T> enumClass) {
        return XmlUtils.getAttributeEnum(node, attributeName, enumClass, null, false);
    }

    public static <T extends Enum<T>> T getAttributeEnum(Node node, String attributeName, Class<T> enumClass, T defaultValue) {
        return XmlUtils.getAttributeEnum(node, attributeName, enumClass, defaultValue, false);
    }

    public static <T extends Enum<T>> T getAttributeEnum(Node node, String attributeName, Class<T> enumClass, T defaultValue, boolean throwOnError) {
        String value = XmlUtils.getAttribute(node, attributeName, null);
        if (value == null || value == "") {
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumClass, value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            if (throwOnError) {
                throw e;
            }
            return defaultValue;
        }
    }

    static {
        _defaultErrorHandler = new DefaultErrorHandler();
        _printJAXPDebug = Boolean.getBoolean("com.gs.XMLEnvCheck");
    }

    private static class DefaultErrorHandler
    implements ErrorHandler {
        private DefaultErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            System.err.println("Parsing warning: " + this.formatException(e));
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw new SAXException("Parsing error: " + this.formatException(e));
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException("Parsing fatal error: " + this.formatException(e));
        }

        private String formatException(SAXParseException spe) {
            Exception ex;
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String exceptionStr = (ex = spe.getException()) != null ? ex.toString() : "";
            String info = "URI=" + systemId + "  Line= " + spe.getLineNumber() + "  Column= " + spe.getColumnNumber() + "  message: " + spe.getMessage() + "  exception: " + exceptionStr;
            return info;
        }
    }
}

