/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.lease;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.internal.DefaultAsyncResult;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.operations.UpdateLeasesSpaceOperationRequest;
import com.gigaspaces.internal.lease.LeaseUpdateBatch;
import com.gigaspaces.internal.lease.SpaceLease;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.exception.internal.InterruptedSpaceException;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class LeaseUtils {
    public static final long DISCARD_LEASE = -1L;

    public static long toExpiration(long duration) {
        long expiration = duration + SystemTime.timeMillis();
        return expiration < 0L ? Long.MAX_VALUE : expiration;
    }

    public static long safeAdd(long x, long y) {
        return x > Long.MAX_VALUE - y ? Long.MAX_VALUE : x + y;
    }

    public static Map<SpaceLease, Throwable> updateBatch(IDirectSpaceProxy spaceProxy, LeaseUpdateBatch batch) {
        UpdateLeasesSpaceOperationRequest request = new UpdateLeasesSpaceOperationRequest(batch.getLeasesUpdateDetails(), batch.isRenew());
        long updateTime = batch.isRenew() ? SystemTime.timeMillis() : 0L;
        try {
            spaceProxy.getProxyRouter().execute(request);
        }
        catch (InterruptedException e) {
            throw new InterruptedSpaceException(e);
        }
        Exception[] errors = request.getFinalResult();
        return LeaseUtils.processResult(errors, batch, updateTime);
    }

    public static void updateBatchAsync(IDirectSpaceProxy spaceProxy, LeaseUpdateBatch batch, AsyncFutureListener<Map<SpaceLease, Throwable>> listener) {
        UpdateLeasesSpaceOperationRequest request = new UpdateLeasesSpaceOperationRequest(batch.getLeasesUpdateDetails(), batch.isRenew());
        spaceProxy.getProxyRouter().executeAsync(request, new ListenerWrapper(batch, listener));
    }

    private static Map<SpaceLease, Throwable> processResult(Exception[] errors, LeaseUpdateBatch batch, long updateTime) {
        HashMap<SpaceLease, Throwable> result;
        block4: {
            block3: {
                HashMap<SpaceLease, Throwable> hashMap = result = errors == null ? null : new HashMap<SpaceLease, Throwable>(errors.length);
                if (errors != null) break block3;
                if (!batch.isRenew()) break block4;
                for (int i = 0; i < batch.getSize(); ++i) {
                    batch.getLeases()[i]._expirationTime = LeaseUtils.safeAdd(updateTime, batch.getLeasesUpdateDetails()[i].getRenewDuration());
                }
                break block4;
            }
            for (int i = 0; i < batch.getSize(); ++i) {
                if (errors[i] != null) {
                    result.put(batch.getLeases()[i], errors[i]);
                    continue;
                }
                if (!batch.isRenew()) continue;
                batch.getLeases()[i]._expirationTime = LeaseUtils.safeAdd(updateTime, batch.getLeasesUpdateDetails()[i].getRenewDuration());
            }
        }
        return result;
    }

    private static class ListenerWrapper
    implements AsyncFutureListener<Object> {
        private final LeaseUpdateBatch batch;
        private final long updateTime;
        private final AsyncFutureListener<Map<SpaceLease, Throwable>> listener;

        public ListenerWrapper(LeaseUpdateBatch batch, AsyncFutureListener<Map<SpaceLease, Throwable>> listener) {
            this.batch = batch;
            this.updateTime = batch.isRenew() ? SystemTime.timeMillis() : 0L;
            this.listener = listener;
        }

        @Override
        public void onResult(AsyncResult<Object> result) {
            Exception error = result.getException();
            Map map = null;
            if (error == null) {
                map = LeaseUtils.processResult((Exception[])result.getResult(), this.batch, this.updateTime);
            }
            if (this.listener != null) {
                this.listener.onResult(new DefaultAsyncResult<Map>(map, error));
            }
        }
    }
}

