/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.lease;

import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.operations.UpdateLeaseSpaceOperationRequest;
import com.gigaspaces.internal.lease.LeaseUtils;
import com.gigaspaces.internal.lease.SpaceLeaseMap;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import com.j_spaces.core.exception.internal.InterruptedSpaceException;
import java.rmi.RemoteException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;

public abstract class SpaceLease
implements Lease,
Textualizable {
    protected final IDirectSpaceProxy _spaceProxy;
    protected final String _typeName;
    protected final String _uid;
    protected final Object _routingValue;
    protected long _expirationTime;
    protected int _serialFormat;

    public SpaceLease(IDirectSpaceProxy spaceProxy, String typeName, String uid, Object routingValue, long expiration) {
        this._spaceProxy = spaceProxy;
        this._typeName = typeName;
        this._uid = uid;
        this._routingValue = routingValue;
        this._expirationTime = expiration;
        this._serialFormat = 1;
    }

    public String toString() {
        return Textualizer.toString(this);
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.append("uid", this._uid);
        textualizer.append("typeName", this._typeName);
        textualizer.append("routingValue", this._routingValue);
        textualizer.append("expirationTime", this._expirationTime);
    }

    public long getExpiration() {
        return this._expirationTime;
    }

    public int getSerialFormat() {
        return this._serialFormat;
    }

    public void setSerialFormat(int serialFormat) {
        if (serialFormat != 1 && serialFormat != 2) {
            throw new IllegalArgumentException("Invalid serial format: " + serialFormat);
        }
        this._serialFormat = serialFormat;
    }

    public void cancel() throws UnknownLeaseException, RemoteException {
        this.updateLease(-1L);
    }

    public void renew(long duration) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        this.updateLease(duration);
        this._expirationTime = LeaseUtils.toExpiration(duration);
    }

    private void updateLease(long duration) throws RemoteException, UnknownLeaseException {
        UpdateLeaseSpaceOperationRequest request = new UpdateLeaseSpaceOperationRequest(this._uid, this._typeName, this.getLeaseObjectType(), duration, this._routingValue);
        try {
            this._spaceProxy.getProxyRouter().execute(request);
        }
        catch (InterruptedException e) {
            throw new InterruptedSpaceException(e);
        }
        request.getFinalResult().processExecutionException();
    }

    public LeaseMap createLeaseMap(long duration) {
        SpaceLeaseMap leaseMap = new SpaceLeaseMap(this._spaceProxy, false);
        leaseMap.put(this, duration);
        return leaseMap;
    }

    public boolean canBatch(Lease lease) {
        if (!(lease instanceof SpaceLease)) {
            return false;
        }
        SpaceLease other = (SpaceLease)lease;
        return this.canBatch(other._spaceProxy);
    }

    public boolean canBatch(IDirectSpaceProxy spaceProxy) {
        return this._spaceProxy == spaceProxy;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public String getUID() {
        return this._uid;
    }

    protected abstract int getLeaseObjectType();
}

