/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.lease;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.lease.LeaseUpdateBatch;
import com.gigaspaces.internal.lease.LeaseUpdateDetails;
import com.gigaspaces.internal.lease.LeaseUtils;
import com.gigaspaces.internal.lease.SpaceLease;
import com.sun.jini.lease.AbstractLeaseMap;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jini.core.lease.LeaseMapException;

@InternalApi
public class SpaceLeaseMap
extends AbstractLeaseMap {
    private final IDirectSpaceProxy _spaceProxy;

    public SpaceLeaseMap(IDirectSpaceProxy spaceProxy, boolean concurrent) {
        super(concurrent ? new ConcurrentHashMap() : new HashMap());
        this._spaceProxy = spaceProxy;
    }

    public boolean canContainKey(Object key) {
        if (key == null || !(key instanceof SpaceLease)) {
            return false;
        }
        return ((SpaceLease)key).canBatch(this._spaceProxy);
    }

    public void renewAll() throws LeaseMapException {
        this.updateAll(true);
    }

    public void cancelAll() throws LeaseMapException {
        this.updateAll(false);
    }

    private void updateAll(boolean isRenew) throws LeaseMapException {
        LeaseUpdateBatch batch = this.createBatch(isRenew);
        Map<SpaceLease, Throwable> errors = LeaseUtils.updateBatch(this._spaceProxy, batch);
        if (errors != null) {
            for (SpaceLease lease : errors.keySet()) {
                if (this.remove(lease) != null) continue;
                throw new ConcurrentModificationException();
            }
            throw new LeaseMapException("Failed to " + (isRenew ? "renew" : "cancel") + " one or more leases", errors);
        }
    }

    private LeaseUpdateBatch createBatch(boolean isRenew) {
        int size = this.size();
        SpaceLease[] leases = new SpaceLease[size];
        LeaseUpdateDetails[] leasesUpdateDetails = new LeaseUpdateDetails[size];
        Iterator iterator = this.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            leases[i] = (SpaceLease)entry.getKey();
            leasesUpdateDetails[i] = new LeaseUpdateDetails(leases[i], isRenew ? (Long)entry.getValue() : -1L);
            ++i;
        }
        return new LeaseUpdateBatch(leases, leasesUpdateDetails, isRenew);
    }
}

