/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.log;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSHelper;
import com.gigaspaces.log.ClientLogEntryMatcherCallback;
import com.gigaspaces.log.CompoundLogEntries;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.logger.RollingFileHandler;
import com.gigaspaces.start.SystemInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

@InternalApi
public class InternalLogHelper {
    private static String lineSeparator = System.getProperty("line.separator");

    public static LogProcessType parseProcessTypeFromSystemProperty() {
        String logFileName = System.getProperty("gs.logFileName");
        if (logFileName != null) {
            logFileName = logFileName.toUpperCase();
            for (LogProcessType logProcessType : LogProcessType.values()) {
                if (!logFileName.contains(logProcessType.name())) continue;
                return logProcessType;
            }
        }
        return null;
    }

    public static LogEntries logEntries(final LogProcessType type, final long pid, LogEntryMatcher matcher) throws IOException {
        if (!RollingFileHandler.isMonitoringCreatedFiles()) {
            throw new IOException("Logger not monitoring created files...");
        }
        File logDir = RollingFileHandler.filesCreated()[0].getParentFile();
        File[] logFiles = BootIOUtils.listFiles((File)logDir, (FilenameFilter)new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String nameInLowerCase = name.toLowerCase();
                String typeNameInLowerCase = type.name().toLowerCase();
                return nameInLowerCase.contains("-" + pid) || nameInLowerCase.contains("_" + pid) && (nameInLowerCase.contains("_" + typeNameInLowerCase) || nameInLowerCase.contains("-" + typeNameInLowerCase));
            }
        });
        if (logFiles.length == 0) {
            OSDetails osDetails = OSHelper.getDetails();
            return new LogEntries(type, pid, osDetails.getHostName(), osDetails.getHostAddress());
        }
        Arrays.sort(logFiles, new NewestToOldestFileComparator());
        return InternalLogHelper.logEntriesDirect(logFiles, pid, type, matcher);
    }

    public static CompoundLogEntries logEntries(LogProcessType[] types, long[] pids, LogEntryMatcher matcher) throws IOException {
        LogEntries[] logEntries = new LogEntries[types.length];
        for (int i = 0; i < types.length; ++i) {
            logEntries[i] = InternalLogHelper.logEntries(types[i], pids[i], matcher);
        }
        return new CompoundLogEntries(logEntries);
    }

    public static CompoundLogEntries logEntries(final LogProcessType type, LogEntryMatcher matcher) throws IOException {
        if (!RollingFileHandler.isMonitoringCreatedFiles()) {
            throw new IOException("Logger not monitoring created files...");
        }
        File logDir = RollingFileHandler.filesCreated()[0].getParentFile();
        File[] logFiles = BootIOUtils.listFiles((File)logDir, (FilenameFilter)new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().contains("-" + type.name().toLowerCase());
            }
        });
        if (logFiles == null || logFiles.length == 0) {
            return new CompoundLogEntries(new LogEntries[0]);
        }
        HashMap<Long, ArrayList<File>> typePerPid = new HashMap<Long, ArrayList<File>>();
        for (File file : logFiles) {
            long pid = InternalLogHelper.extractPid(file);
            ArrayList<File> list = (ArrayList<File>)typePerPid.get(pid);
            if (list == null) {
                list = new ArrayList<File>();
                typePerPid.put(pid, list);
            }
            list.add(file);
        }
        ArrayList<LogEntries> logEntries = new ArrayList<LogEntries>();
        for (Map.Entry entry : typePerPid.entrySet()) {
            logEntries.add(InternalLogHelper.logEntriesDirect(((List)entry.getValue()).toArray(new File[((List)entry.getValue()).size()]), (Long)entry.getKey(), type, matcher));
        }
        LogEntries[] result = logEntries.toArray(new LogEntries[logEntries.size()]);
        Arrays.sort(result, new Comparator<LogEntries>(){

            @Override
            public int compare(LogEntries o1, LogEntries o2) {
                return (int)(o1.getLatestLogFileTimestamp() - o2.getLatestLogFileTimestamp());
            }
        });
        return new CompoundLogEntries(result);
    }

    private static long extractPid(File file) {
        int lastDashIdx = file.getName().lastIndexOf(45);
        int dotIdx = file.getName().indexOf(46, lastDashIdx);
        return Long.parseLong(file.getName().substring(lastDashIdx + 1, dotIdx));
    }

    public static LogEntries logEntriesDirect(LogProcessType type, LogEntryMatcher matcher) throws IOException {
        if (!RollingFileHandler.isMonitoringCreatedFiles()) {
            throw new IOException("Logger not monitoring created files...");
        }
        File[] files = RollingFileHandler.filesCreated();
        return InternalLogHelper.logEntriesDirect(files, SystemInfo.singleton().os().processId(), type, matcher);
    }

    public static File[] logFiles() throws IOException {
        if (!RollingFileHandler.isMonitoringCreatedFiles()) {
            throw new IOException("Logger not monitoring created files...");
        }
        return RollingFileHandler.filesCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogEntries logEntriesDirect(File[] files, long pid, LogProcessType type, LogEntryMatcher matcher) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        OSDetails osDetails = OSHelper.getDetails();
        matcher.initialize(new LogEntryMatcher.InitializationContext(osDetails.getHostAddress(), osDetails.getHostName(), pid, type));
        StringBuilder sb = new StringBuilder();
        File latestFile = files[0];
        for (int fileIndex = 0; fileIndex < files.length; ++fileIndex) {
            File file = files[fileIndex];
            ArrayList<String> lines = new ArrayList<String>();
            BackwardsFileInputStream fileInputStream = new BackwardsFileInputStream(file);
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(fileInputStream));
                LogEntryMatcher.Operation operation = matcher.match(new LogEntry(files.length - 1 - fileIndex, LogEntry.Type.FILE_MARKER, file.lastModified(), file.getAbsolutePath()));
                if (operation == LogEntryMatcher.Operation.BREAK) break;
                if (operation == LogEntryMatcher.Operation.IGNORE) continue;
                boolean firstLine = true;
                long position = fileInputStream.position() + (long)lineSeparator.length();
                while ((line = reader.readLine()) != null) {
                    String logText;
                    Date timestamp;
                    if (firstLine) {
                        if (line.length() == 0) continue;
                        firstLine = false;
                    }
                    char[] chars = line.toCharArray();
                    int j = 0;
                    for (int k = chars.length - 1; j < k; ++j, --k) {
                        char temp = chars[j];
                        chars[j] = chars[k];
                        chars[k] = temp;
                    }
                    position -= (long)(chars.length + lineSeparator.length());
                    line = new String(chars);
                    int idx = line.indexOf(32);
                    if (idx == -1) {
                        lines.add(line);
                        continue;
                    }
                    if ((idx = line.indexOf(32, idx + 1)) == -1) {
                        lines.add(line);
                        continue;
                    }
                    try {
                        timestamp = dateFormat.parse(line.substring(0, idx));
                    }
                    catch (ParseException e) {
                        lines.add(line);
                        continue;
                    }
                    if (lines.isEmpty()) {
                        logText = line;
                    } else {
                        sb.setLength(0);
                        sb.append(line).append(lineSeparator);
                        for (int i = lines.size() - 1; i >= 0 && (i != 0 || ((String)lines.get(i)).length() != 0); --i) {
                            sb.append((String)lines.get(i));
                            if (i == 0) continue;
                            sb.append(lineSeparator);
                        }
                        logText = sb.toString();
                    }
                    if (matcher.match(new LogEntry(position, LogEntry.Type.LOG, timestamp.getTime(), logText)) == LogEntryMatcher.Operation.BREAK) {
                        LogEntries logEntries = InternalLogHelper.toEntries(type, pid, files, matcher.entries(), latestFile.lastModified());
                        return logEntries;
                    }
                    lines.clear();
                }
                continue;
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return InternalLogHelper.toEntries(type, pid, files, matcher.entries(), latestFile.lastModified());
    }

    public static LogEntries clientSideProcess(LogEntryMatcher matcher, LogEntries entries) {
        if (matcher instanceof ClientLogEntryMatcherCallback) {
            return ((ClientLogEntryMatcherCallback)matcher).clientSideProcess(entries);
        }
        return entries;
    }

    private static LogEntries toEntries(LogProcessType type, long pid, File[] files, List<LogEntry> entries, long latestLogTimestamp) {
        LinkedList<LogEntry> reveredEntries = new LinkedList<LogEntry>();
        LogEntry fileMarker = null;
        ListIterator<LogEntry> it = entries.listIterator(entries.size());
        while (it.hasPrevious()) {
            LogEntry entry = it.previous();
            if (entry.isFileMarker()) {
                if (fileMarker != null) {
                    reveredEntries.addFirst(fileMarker);
                }
                fileMarker = entry;
                continue;
            }
            reveredEntries.add(entry);
        }
        if (fileMarker != null) {
            reveredEntries.addFirst(fileMarker);
        }
        OSDetails osDetails = OSHelper.getDetails();
        return new LogEntries(type, reveredEntries, files.length, pid, latestLogTimestamp, osDetails.getHostName(), osDetails.getHostAddress());
    }

    public static class BackwardsFileInputStream
    extends InputStream {
        private final byte[] buffer = new byte[16384];
        private final RandomAccessFile raf;
        private long currentPositionInFile;
        private int currentPositionInBuffer;

        public BackwardsFileInputStream(File file) throws IOException {
            assert (file != null && file.exists() && file.isFile() && file.canRead());
            this.raf = new RandomAccessFile(file, "r");
            this.currentPositionInFile = this.raf.length();
            this.currentPositionInBuffer = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.currentPositionInFile <= 0L) {
                return -1;
            }
            if (--this.currentPositionInBuffer < 0) {
                this.currentPositionInBuffer = this.buffer.length;
                long startOfBlock = this.currentPositionInFile - (long)this.buffer.length;
                if (startOfBlock < 0L) {
                    this.currentPositionInBuffer = this.buffer.length + (int)startOfBlock;
                    startOfBlock = 0L;
                }
                this.raf.seek(startOfBlock);
                this.raf.readFully(this.buffer, 0, this.currentPositionInBuffer);
                return this.read();
            }
            --this.currentPositionInFile;
            byte retVal = this.buffer[this.currentPositionInBuffer];
            if (retVal == 13) {
                return this.read();
            }
            return retVal;
        }

        public long position() {
            return this.currentPositionInFile + (long)this.currentPositionInBuffer;
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }
    }

    private static class NewestToOldestFileComparator
    implements Comparator<File> {
        private NewestToOldestFileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            if (o1.lastModified() > o2.lastModified()) {
                return -1;
            }
            if (o1.lastModified() == o2.lastModified()) {
                return 0;
            }
            return 1;
        }
    }
}

