/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.lookup;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.kernel.ClassLoaderHelper;
import com.j_spaces.kernel.ResourceLoader;
import com.sun.jini.reggie.GigaRegistrar;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.start.LifeCycle;
import java.lang.reflect.Constructor;

@InternalApi
public class RegistrarFactory {
    public static boolean isActive() {
        return GigaRegistrar.isActive();
    }

    public static Registrar createRegistrar(String[] config, LifeCycle lifeCycle) throws Exception {
        Class<?> registrarClass = RegistrarFactory.getRegistrarClass();
        Constructor<?> constructor = registrarClass.getDeclaredConstructor(String[].class, LifeCycle.class);
        constructor.setAccessible(true);
        return (Registrar)constructor.newInstance(config, lifeCycle);
    }

    public static Registrar createRegistrar() throws Exception {
        String config = ResourceLoader.getServicesConfigUrl().toExternalForm();
        return RegistrarFactory.createRegistrar(new String[]{config}, null);
    }

    public static Registrar createRegistrar(String lookupGroups) throws Exception {
        String previousLookupGroup = SystemInfo.singleton().lookup().setGroups(lookupGroups);
        Registrar registrar = RegistrarFactory.createRegistrar();
        SystemInfo.singleton().lookup().setGroups(previousLookupGroup);
        return registrar;
    }

    private static Class<?> getRegistrarClass() {
        try {
            return ClassLoaderHelper.loadClass("com.gigaspaces.grid.lookup.ServiceGridRegistrar");
        }
        catch (Throwable e) {
            return GigaRegistrar.class;
        }
    }
}

