/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.lookup;

import com.gigaspaces.internal.utils.StringUtils;
import net.jini.core.discovery.LookupLocator;

public abstract class SpaceUrlUtils {
    public static boolean isRemoteProtocol(String spaceUrl) {
        return StringUtils.startsWithIgnoreCase(spaceUrl, "jini:") || StringUtils.startsWithIgnoreCase(spaceUrl, "rmi:");
    }

    public static String toCustomUrlProperty(String propertyName) {
        return "gs.space.url.arg." + propertyName;
    }

    public static String buildJiniUrl(String containerName, String spaceName, String[] groups, LookupLocator[] locators) {
        StringBuilder sb = SpaceUrlUtils.buildPrefix(containerName, spaceName);
        boolean hasProperties = false;
        hasProperties = SpaceUrlUtils.appendGroups(sb, groups, hasProperties);
        hasProperties = SpaceUrlUtils.appendLocators(locators, sb, hasProperties);
        return sb.toString();
    }

    public static String buildJiniUrl(String containerName, String spaceName, String groups, String locators) {
        StringBuilder sb = SpaceUrlUtils.buildPrefix(containerName, spaceName);
        boolean hasProperties = false;
        hasProperties = SpaceUrlUtils.appendProperty(sb, "groups", groups, hasProperties);
        hasProperties = SpaceUrlUtils.appendProperty(sb, "locators", locators, hasProperties);
        return sb.toString();
    }

    public static String setPropertyInUrl(String url, String name, String value) {
        return SpaceUrlUtils.setPropertyInUrl(url, name, value, true);
    }

    public static String setPropertyInUrl(String url, String name, String value, boolean overrideIfExists) {
        int startIndex = SpaceUrlUtils.indexOf(url, name);
        if (startIndex == -1) {
            char separator = url.lastIndexOf(63) == -1 ? (char)'?' : '&';
            url = url + separator + name + (value != null ? '=' + value : "");
        } else if (overrideIfExists) {
            int endIndex = url.indexOf(38, startIndex + 1);
            if (endIndex < 0) {
                endIndex = url.length();
            }
            String newValue = StringUtils.hasLength(value) ? name + '=' + value : name;
            StringBuilder sb = new StringBuilder(url);
            sb.replace(startIndex + 1, endIndex, newValue);
            url = sb.toString();
        }
        return url;
    }

    public static String deletePropertyFromUrl(String url, String name) {
        int startIndex = SpaceUrlUtils.indexOf(url, name) + 1;
        if (startIndex == 0) {
            return url;
        }
        int endIndex = url.indexOf(38, startIndex) + 1;
        if (endIndex == 0) {
            endIndex = url.length();
            --startIndex;
        }
        StringBuilder sb = new StringBuilder(url);
        sb.delete(startIndex, endIndex);
        url = sb.toString();
        return url;
    }

    private static int indexOf(String url, String attName) {
        int pos = StringUtils.indexOfIgnoreCase(url, '&' + attName + '=');
        if (pos != -1) {
            return pos;
        }
        pos = StringUtils.indexOfIgnoreCase(url, '?' + attName + '=');
        if (pos != -1) {
            return pos;
        }
        pos = StringUtils.indexOfIgnoreCase(url, '?' + attName + '&');
        if (pos != -1) {
            return pos;
        }
        pos = StringUtils.indexOfIgnoreCase(url, '&' + attName + '&');
        if (pos != -1) {
            return pos;
        }
        if (StringUtils.endsWithIgnoreCase(url, '?' + attName) || StringUtils.endsWithIgnoreCase(url, '&' + attName)) {
            return url.length() - attName.length() - 1;
        }
        return -1;
    }

    private static StringBuilder buildPrefix(String containerName, String spaceName) {
        StringBuilder sb = new StringBuilder().append("jini:").append("//").append("*").append('/').append(StringUtils.hasLength(containerName) ? containerName : "*").append('/').append(spaceName);
        return sb;
    }

    private static boolean appendProperty(StringBuilder sb, String key, String value, boolean hasProperties) {
        if (value == null || value.length() == 0) {
            return hasProperties;
        }
        sb.append(hasProperties ? (char)'&' : '?');
        sb.append(key);
        sb.append('=');
        sb.append(value);
        return true;
    }

    private static boolean appendGroups(StringBuilder sb, String[] groups, boolean hasProperties) {
        if (groups == null || groups.length == 0) {
            return hasProperties;
        }
        sb.append(hasProperties ? (char)'&' : '?');
        sb.append("groups");
        sb.append('=');
        sb.append(groups[0]);
        for (int i = 1; i < groups.length; ++i) {
            sb.append(',');
            sb.append(groups[i]);
        }
        return true;
    }

    private static boolean appendLocators(LookupLocator[] locators, StringBuilder sb, boolean hasProperties) {
        if (locators == null || locators.length == 0) {
            return hasProperties;
        }
        sb.append(hasProperties ? (char)'&' : '?');
        sb.append("locators");
        sb.append('=');
        sb.append(locators[0].getHost());
        sb.append(':');
        sb.append(locators[0].getPort());
        for (int i = 1; i < locators.length; ++i) {
            sb.append(',');
            sb.append(locators[i].getHost());
            sb.append(':');
            sb.append(locators[i].getPort());
        }
        return true;
    }
}

