/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.lrmi;

import com.gigaspaces.api.InternalApi;
import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalApi
public class ConnectionUrlDescriptor {
    private final String _protocol;
    private final String _hostname;
    private final int _port;
    private final long _pid;
    private final long _objectId;
    private final long _objectClassLoaderId;
    private final long _lrmiRuntimeId;
    private final String _serviceDetails;
    private static final String SEPARATOR_1 = "://";
    private static final String SEPARATOR_2 = ":";
    private static final String SEPARATOR_3 = "/pid[";
    private static final String SEPARATOR_4 = "]/";
    private static final String SEPARATOR_5 = "_";
    private static final String SEPARATOR_6 = "_";
    private static final String SEPARATOR_7 = "_details[";
    private static final String SEPARATOR_8 = "]";
    private static final String GROUP_ANY = "(.*)";
    private static final String GROUP_ANY_POSITIVE_NUMBER = "([1-9][0-9]*)";
    private static final String GROUP_ANY_NUMBER = "(-?[0-9]+)";
    private static final String PROTOCOL = "(.*)";
    private static final String HOSTNAME = "(.*)";
    private static final String PORT = "([1-9][0-9]*)";
    private static final String PID = "([1-9][0-9]*)";
    private static final String OJBECT_ID = "(-?[0-9]+)";
    private static final String OBJECT_CLASSLOADER_ID = "(-?[0-9]+)";
    private static final String LRMI_RUNTIME_ID = "(-?[0-9]+)";
    private static final String SERVICE_DETAILS = "(.*)";
    private static final String CONNECTION_URL_REGEX = "(.*)" + Pattern.quote("://") + "(.*)" + Pattern.quote(":") + "([1-9][0-9]*)" + Pattern.quote("/pid[") + "([1-9][0-9]*)" + Pattern.quote("]/") + "(-?[0-9]+)" + Pattern.quote("_") + "(-?[0-9]+)" + Pattern.quote("_") + "(-?[0-9]+)" + "(?:" + Pattern.quote("_details[") + "(.*)" + Pattern.quote("]") + ")?";
    private static final Pattern CONNECTION_URL_PATTERN = Pattern.compile(CONNECTION_URL_REGEX);

    public ConnectionUrlDescriptor(String protocol, String hostname, int port, long pid, long objectId, long objectClassLoaderId, long lrmiRuntimeId, String serviceDetails) {
        this._protocol = protocol;
        this._hostname = hostname;
        this._port = port;
        this._pid = pid;
        this._objectId = objectId;
        this._objectClassLoaderId = objectClassLoaderId;
        this._lrmiRuntimeId = lrmiRuntimeId;
        this._serviceDetails = serviceDetails;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this._hostname, this._port);
    }

    public long getPid() {
        return this._pid;
    }

    public long getObjectId() {
        return this._objectId;
    }

    public long getObjectClassLoaderId() {
        return this._objectClassLoaderId;
    }

    public long getLrmiRuntimeId() {
        return this._lrmiRuntimeId;
    }

    public String getServiceDetails() {
        return this._serviceDetails;
    }

    public String toString() {
        return this.toUrl();
    }

    public String toUrl() {
        StringBuilder url = new StringBuilder().append(this._protocol).append(SEPARATOR_1).append(this._hostname).append(SEPARATOR_2).append(this._port).append(SEPARATOR_3).append(this._pid).append(SEPARATOR_4).append(this._objectId).append("_").append(this._objectClassLoaderId).append("_").append(this._lrmiRuntimeId).append(SEPARATOR_7).append(this._serviceDetails).append(SEPARATOR_8);
        return url.toString();
    }

    public static ConnectionUrlDescriptor fromUrl(String connectionUrl) {
        if (connectionUrl == null) {
            throw new IllegalArgumentException("connectionUrl is null");
        }
        Matcher matcher = CONNECTION_URL_PATTERN.matcher(connectionUrl);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Malformed connectionUrl: " + connectionUrl);
        }
        String protocol = matcher.group(1);
        String hostname = matcher.group(2);
        int port = Integer.parseInt(matcher.group(3));
        int pid = Integer.parseInt(matcher.group(4));
        long objectId = Long.parseLong(matcher.group(5));
        long objectClassLoaderId = Long.parseLong(matcher.group(6));
        long lrmiRuntimeId = Long.parseLong(matcher.group(7));
        String serviceDetails = matcher.group(8);
        return new ConnectionUrlDescriptor(protocol, hostname, port, pid, objectId, objectClassLoaderId, lrmiRuntimeId, serviceDetails);
    }
}

