/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.LRMIMethodMonitoringDetails;
import com.gigaspaces.lrmi.LRMIUtilities;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class LRMIMethodMonitoringDetailsImpl
implements Externalizable,
LRMIMethodMonitoringDetails {
    private static final long serialVersionUID = 1L;
    private long _generatedTraffic;
    private long _receivedTraffic;
    private long _invocationCount;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._generatedTraffic);
        out.writeLong(this._receivedTraffic);
        out.writeLong(this._invocationCount);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._generatedTraffic = in.readLong();
        this._receivedTraffic = in.readLong();
        this._invocationCount = in.readLong();
    }

    public void addTrackingDetails(long thisInvocationGeneratedTraffic, long thisInvocationReceivedTraffic) {
        ++this._invocationCount;
        this._generatedTraffic += thisInvocationGeneratedTraffic;
        this._receivedTraffic += thisInvocationReceivedTraffic;
    }

    @Override
    public long getInvocationCount() {
        return this._invocationCount;
    }

    @Override
    public long getGeneratedTraffic() {
        return this._generatedTraffic;
    }

    @Override
    public long getReceivedTraffic() {
        return this._receivedTraffic;
    }

    public void addTrackingDetails(LRMIMethodMonitoringDetails methodTrackingDetails) {
        this._invocationCount += methodTrackingDetails.getInvocationCount();
        this._generatedTraffic += methodTrackingDetails.getGeneratedTraffic();
        this._receivedTraffic += methodTrackingDetails.getReceivedTraffic();
    }

    public String toString() {
        return "invoked count=" + this._invocationCount + " received traffic=" + LRMIUtilities.getTrafficString(this._receivedTraffic) + " generated traffic=" + LRMIUtilities.getTrafficString(this._generatedTraffic) + " total traffic=" + LRMIUtilities.getTrafficString(this._receivedTraffic + this._generatedTraffic);
    }
}

