/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.lrmi.LRMIMethodMonitoringDetailsImpl;
import com.gigaspaces.lrmi.LRMIMethodMonitoringDetails;
import com.gigaspaces.lrmi.nio.Pivot;
import com.gigaspaces.lrmi.nio.Reader;
import com.gigaspaces.lrmi.nio.Writer;
import java.util.Map;

@InternalApi
public class LRMIMonitoringModule {
    private final Map<String, LRMIMethodMonitoringDetailsImpl> _monitoringDetails = CollectionsFactory.getInstance().createMap();
    private long _lastMonitoredGeneratedTraffic;
    private long _lastMonitoredReceivedTraffic;

    public void monitorActivity(String monitoringId, Writer writer, Reader reader) {
        if (!Pivot.isMonitorActivity() || monitoringId == null || writer == null || reader == null) {
            return;
        }
        LRMIMethodMonitoringDetailsImpl methodMonitoringDetails = this._monitoringDetails.get(monitoringId);
        if (methodMonitoringDetails == null) {
            methodMonitoringDetails = new LRMIMethodMonitoringDetailsImpl();
            this._monitoringDetails.put(monitoringId, methodMonitoringDetails);
        }
        long generatedTraffic = writer.getGeneratedTraffic();
        long thisInvocationGeneratedTraffic = Math.max(0L, generatedTraffic - this._lastMonitoredGeneratedTraffic);
        this._lastMonitoredGeneratedTraffic = generatedTraffic;
        long receivedTraffic = reader.getReceivedTraffic();
        long thisInvocationReceivedTraffic = Math.max(0L, receivedTraffic - this._lastMonitoredReceivedTraffic);
        this._lastMonitoredReceivedTraffic = receivedTraffic;
        methodMonitoringDetails.addTrackingDetails(thisInvocationGeneratedTraffic, thisInvocationReceivedTraffic);
    }

    public void addMonitoringActivity(Map<String, LRMIMethodMonitoringDetails> trackingDetails) {
        try {
            for (Map.Entry<String, LRMIMethodMonitoringDetailsImpl> methodTrackingDetailsEntry : this._monitoringDetails.entrySet()) {
                LRMIMethodMonitoringDetailsImpl methodTrackingDetails = (LRMIMethodMonitoringDetailsImpl)trackingDetails.get(methodTrackingDetailsEntry.getKey());
                if (methodTrackingDetails == null) {
                    methodTrackingDetails = new LRMIMethodMonitoringDetailsImpl();
                    trackingDetails.put(methodTrackingDetailsEntry.getKey(), methodTrackingDetails);
                }
                methodTrackingDetails.addTrackingDetails(methodTrackingDetailsEntry.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

