/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.lrmi.ConnectionUrlDescriptor;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.ConnectionResource;
import com.gigaspaces.lrmi.LRMIMethodMonitoringDetails;
import com.gigaspaces.lrmi.LRMIProxyMonitoringDetails;
import com.gigaspaces.lrmi.LRMIUtilities;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

@InternalApi
public class LRMIProxyMonitoringDetailsImpl
implements LRMIProxyMonitoringDetails,
Externalizable {
    private static final long serialVersionUID = 1L;
    private long _totalReceivedTraffic;
    private long _totalGeneratedTraffic;
    private String _connectionURL;
    private String _serviceDetails;
    private Map<String, LRMIMethodMonitoringDetails> _monitoringDetails;
    private PlatformLogicalVersion _serviceVersion;

    public LRMIProxyMonitoringDetailsImpl() {
    }

    public LRMIProxyMonitoringDetailsImpl(String connectionURL, String serviceDetails, PlatformLogicalVersion serviceVersion) {
        this._connectionURL = connectionURL;
        this._serviceDetails = serviceDetails;
        this._serviceVersion = serviceVersion;
    }

    @Override
    public long getTotalReceivedTraffic() {
        return this._totalReceivedTraffic;
    }

    @Override
    public long getTotalGeneratedTraffic() {
        return this._totalGeneratedTraffic;
    }

    @Override
    public String getConnectionUrl() {
        return this._connectionURL;
    }

    @Override
    public String getServiceDetails() {
        return this._serviceDetails;
    }

    @Override
    public PlatformLogicalVersion getServiceVersion() {
        return this._serviceVersion;
    }

    @Override
    public Map<String, LRMIMethodMonitoringDetails> getTrackingDetails() {
        return this._monitoringDetails;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._totalReceivedTraffic);
        out.writeLong(this._totalGeneratedTraffic);
        IOUtils.writeString(out, this._connectionURL);
        IOUtils.writeString(out, this._serviceDetails);
        IOUtils.writeObject(out, this._serviceVersion);
        IOUtils.writeObject(out, this._monitoringDetails);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._totalReceivedTraffic = in.readLong();
        this._totalGeneratedTraffic = in.readLong();
        this._connectionURL = IOUtils.readString(in);
        this._serviceDetails = IOUtils.readString(in);
        this._serviceVersion = (PlatformLogicalVersion)IOUtils.readObject(in);
        this._monitoringDetails = (Map)IOUtils.readObject(in);
    }

    public void addConnectionResource(ConnectionResource resource) {
        this._totalReceivedTraffic += resource.getReceivedTraffic();
        this._totalGeneratedTraffic += resource.getGeneratedTraffic();
        if (this._monitoringDetails == null) {
            this._monitoringDetails = new HashMap<String, LRMIMethodMonitoringDetails>();
        }
        resource.getMonitoringModule().addMonitoringActivity(this._monitoringDetails);
    }

    @Override
    public long getServicePid() {
        return ConnectionUrlDescriptor.fromUrl(this._connectionURL).getPid();
    }

    @Override
    public String getServiceHostname() {
        return ConnectionUrlDescriptor.fromUrl(this._connectionURL).getHostname();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LRMIProxyMonitoringDetails (ServiceDetails=" + this.getServiceDetails() + " TotalReceivedTraffic=");
        builder.append(LRMIUtilities.getTrafficString(this.getTotalReceivedTraffic()));
        builder.append(" TotalGeneratedTraffic=");
        builder.append(LRMIUtilities.getTrafficString(this.getTotalGeneratedTraffic()));
        builder.append(" TotalTraffic=");
        builder.append(LRMIUtilities.getTrafficString(this.getTotalReceivedTraffic() + this.getTotalGeneratedTraffic()));
        builder.append(StringUtils.NEW_LINE);
        builder.append(" ConnectionUrl=");
        builder.append(this.getConnectionUrl());
        builder.append(" ServiceVersion=");
        builder.append(this.getServiceVersion());
        builder.append(")");
        if (this._monitoringDetails != null) {
            LinkedList<Map.Entry<String, LRMIMethodMonitoringDetails>> list = new LinkedList<Map.Entry<String, LRMIMethodMonitoringDetails>>(this._monitoringDetails.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, LRMIMethodMonitoringDetails>>(){

                @Override
                public int compare(Map.Entry<String, LRMIMethodMonitoringDetails> o1, Map.Entry<String, LRMIMethodMonitoringDetails> o2) {
                    long o2Traffic;
                    long o1Traffic = o1.getValue().getGeneratedTraffic() + o1.getValue().getReceivedTraffic();
                    if (o1Traffic == (o2Traffic = o2.getValue().getGeneratedTraffic() + o2.getValue().getReceivedTraffic())) {
                        return 0;
                    }
                    return o1Traffic < o2Traffic ? 1 : -1;
                }
            });
            builder.append(StringUtils.NEW_LINE);
            for (Map.Entry entry : list) {
                builder.append("\t\t");
                builder.append((String)entry.getKey());
                builder.append(": ");
                builder.append(entry.getValue());
                builder.append(StringUtils.NEW_LINE);
            }
        }
        return builder.toString();
    }
}

