/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIMethodMonitoringDetails;
import com.gigaspaces.lrmi.LRMIServiceClientMonitoringDetails;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.gigaspaces.lrmi.nio.ChannelEntry;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

@InternalApi
public class LRMIServiceClientMonitoringDetailsImpl
implements Externalizable,
LRMIServiceClientMonitoringDetails {
    private static final long serialVersionUID = 1L;
    private long _totalReceivedTraffic;
    private long _totalGeneratedTraffic;
    private PlatformLogicalVersion _clientVersion;
    private Map<String, LRMIMethodMonitoringDetails> _monitoringDetails;

    public LRMIServiceClientMonitoringDetailsImpl() {
    }

    public LRMIServiceClientMonitoringDetailsImpl(PlatformLogicalVersion clientVersion) {
        this._clientVersion = clientVersion;
    }

    void addChannelDetails(ChannelEntry channelEntry) {
        this._totalReceivedTraffic += channelEntry.getReceivedTraffic();
        this._totalGeneratedTraffic += channelEntry.getGeneratedTraffic();
        if (this._monitoringDetails == null) {
            this._monitoringDetails = new HashMap<String, LRMIMethodMonitoringDetails>();
        }
        channelEntry.getMonitoringModule().addMonitoringActivity(this._monitoringDetails);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._totalReceivedTraffic);
        out.writeLong(this._totalGeneratedTraffic);
        out.writeObject(this._monitoringDetails);
        out.writeObject(this._clientVersion);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._totalReceivedTraffic = in.readLong();
        this._totalGeneratedTraffic = in.readLong();
        this._monitoringDetails = (Map)in.readObject();
        this._clientVersion = (PlatformLogicalVersion)in.readObject();
    }

    @Override
    public long getTotalReceivedTraffic() {
        return this._totalReceivedTraffic;
    }

    @Override
    public long getTotalGeneratedTraffic() {
        return this._totalGeneratedTraffic;
    }

    @Override
    public PlatformLogicalVersion getVersion() {
        return this._clientVersion;
    }

    @Override
    public Map<String, LRMIMethodMonitoringDetails> getTrackingDetails() {
        return this._monitoringDetails;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LRMIServiceClientTrackingDetails (TotalReceivedTraffic=");
        builder.append(LRMIUtilities.getTrafficString(this.getTotalReceivedTraffic()));
        builder.append(" TotalGeneratedTraffic=");
        builder.append(LRMIUtilities.getTrafficString(this.getTotalGeneratedTraffic()));
        builder.append(" TotalTraffic=");
        builder.append(LRMIUtilities.getTrafficString(this.getTotalReceivedTraffic() + this.getTotalGeneratedTraffic()));
        builder.append(" ClientVersion=");
        builder.append(this.getVersion());
        builder.append(")");
        if (this._monitoringDetails != null) {
            LinkedList<Map.Entry<String, LRMIMethodMonitoringDetails>> list = new LinkedList<Map.Entry<String, LRMIMethodMonitoringDetails>>(this._monitoringDetails.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, LRMIMethodMonitoringDetails>>(){

                @Override
                public int compare(Map.Entry<String, LRMIMethodMonitoringDetails> o1, Map.Entry<String, LRMIMethodMonitoringDetails> o2) {
                    long o2Traffic;
                    long o1Traffic = o1.getValue().getGeneratedTraffic() + o1.getValue().getReceivedTraffic();
                    if (o1Traffic == (o2Traffic = o2.getValue().getGeneratedTraffic() + o2.getValue().getReceivedTraffic())) {
                        return 0;
                    }
                    return o1Traffic < o2Traffic ? 1 : -1;
                }
            });
            builder.append(StringUtils.NEW_LINE);
            for (Map.Entry entry : list) {
                builder.append("\t\t");
                builder.append((String)entry.getKey());
                builder.append(": ");
                builder.append(entry.getValue());
                builder.append(StringUtils.NEW_LINE);
            }
        }
        return builder.toString();
    }
}

