/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.lrmi.LRMIServiceClientMonitoringDetailsImpl;
import com.gigaspaces.internal.lrmi.LRMIServiceClientMonitoringIdImpl;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.lrmi.LRMIServiceClientMonitoringDetails;
import com.gigaspaces.lrmi.LRMIServiceClientMonitoringId;
import com.gigaspaces.lrmi.LRMIServiceMonitoringDetails;
import com.gigaspaces.lrmi.nio.ChannelEntry;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

@InternalApi
public class LRMIServiceMonitoringDetailsImpl
implements Externalizable,
LRMIServiceMonitoringDetails {
    private static final long serialVersionUID = 1L;
    private String _serviceDetails;
    private String _serviceClassLoaderDetails;
    private long _remoteObjID;
    private String _connectionUrl;
    private Map<LRMIServiceClientMonitoringId, LRMIServiceClientMonitoringDetails> _clientsMonitoringDetails;

    public LRMIServiceMonitoringDetailsImpl() {
    }

    public LRMIServiceMonitoringDetailsImpl(String serviceDetails, String serviceClassLoaderDetails, long remoteObjID, String connectionUrl) {
        this._serviceDetails = serviceDetails;
        this._serviceClassLoaderDetails = serviceClassLoaderDetails;
        this._remoteObjID = remoteObjID;
        this._connectionUrl = connectionUrl;
        this._clientsMonitoringDetails = new HashMap<LRMIServiceClientMonitoringId, LRMIServiceClientMonitoringDetails>();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._serviceDetails);
        IOUtils.writeString(out, this._serviceClassLoaderDetails);
        IOUtils.writeString(out, this._connectionUrl);
        out.writeLong(this._remoteObjID);
        IOUtils.writeObject(out, this._clientsMonitoringDetails);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._serviceDetails = IOUtils.readString(in);
        this._serviceClassLoaderDetails = IOUtils.readString(in);
        this._connectionUrl = IOUtils.readString(in);
        this._remoteObjID = in.readLong();
        this._clientsMonitoringDetails = (Map)IOUtils.readObject(in);
    }

    public void addChannelDetails(ChannelEntry channelEntry) {
        Socket socket = channelEntry.getSocketChannel().socket();
        if (socket == null) {
            return;
        }
        InetAddress remoteInetAddress = socket.getInetAddress();
        if (remoteInetAddress == null) {
            return;
        }
        long sourcePid = channelEntry.getSourcePid();
        LRMIServiceClientMonitoringIdImpl clientId = new LRMIServiceClientMonitoringIdImpl(remoteInetAddress, sourcePid);
        LRMIServiceClientMonitoringDetailsImpl clientMonitoringDetails = (LRMIServiceClientMonitoringDetailsImpl)this._clientsMonitoringDetails.get(clientId);
        if (clientMonitoringDetails == null) {
            clientMonitoringDetails = new LRMIServiceClientMonitoringDetailsImpl(channelEntry.getSourcePlatformLogicalVersion());
            this._clientsMonitoringDetails.put(clientId, clientMonitoringDetails);
        }
        clientMonitoringDetails.addChannelDetails(channelEntry);
    }

    @Override
    public String getServiceDetails() {
        return this._serviceDetails;
    }

    @Override
    public String getServiceClassLoaderDetails() {
        return this._serviceClassLoaderDetails;
    }

    @Override
    public long getRemoteObjID() {
        return this._remoteObjID;
    }

    @Override
    public String getConnectionUrl() {
        return this._connectionUrl;
    }

    @Override
    public Map<LRMIServiceClientMonitoringId, LRMIServiceClientMonitoringDetails> getClientsTrackingDetails() {
        return this._clientsMonitoringDetails;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LRMIServiceTrackingDetails (ServiceDetails=");
        builder.append(this.getServiceDetails());
        builder.append(" ServiceClassLoaderDetails=");
        builder.append(this.getServiceClassLoaderDetails());
        builder.append(" RemoteObjectId=");
        builder.append(this.getRemoteObjID());
        builder.append(StringUtils.NEW_LINE);
        builder.append(" ConnectionUrl=");
        builder.append(this.getConnectionUrl());
        builder.append(")");
        builder.append(StringUtils.NEW_LINE);
        LinkedList<Map.Entry<LRMIServiceClientMonitoringId, LRMIServiceClientMonitoringDetails>> list = new LinkedList<Map.Entry<LRMIServiceClientMonitoringId, LRMIServiceClientMonitoringDetails>>(this._clientsMonitoringDetails.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<LRMIServiceClientMonitoringId, LRMIServiceClientMonitoringDetails>>(){

            @Override
            public int compare(Map.Entry<LRMIServiceClientMonitoringId, LRMIServiceClientMonitoringDetails> o1, Map.Entry<LRMIServiceClientMonitoringId, LRMIServiceClientMonitoringDetails> o2) {
                long o2Traffic;
                long o1Traffic = o1.getValue().getTotalGeneratedTraffic() + o1.getValue().getTotalReceivedTraffic();
                if (o1Traffic == (o2Traffic = o2.getValue().getTotalGeneratedTraffic() + o2.getValue().getTotalReceivedTraffic())) {
                    return 0;
                }
                return o1Traffic < o2Traffic ? 1 : -1;
            }
        });
        for (Map.Entry entry : list) {
            builder.append("\t");
            builder.append(entry.getKey());
            builder.append(":");
            builder.append(StringUtils.NEW_LINE);
            builder.append("\t\t");
            builder.append(entry.getValue());
            builder.append(StringUtils.NEW_LINE);
        }
        return builder.toString();
    }
}

