/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.lrmi.stubs;

import com.gigaspaces.annotation.lrmi.OneWayRemoteCall;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.ManagedRemoteEventListener;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.lrmi.OneWayMethodRepository;
import com.gigaspaces.lrmi.RemoteStub;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;

@InternalApi
public class LRMIRemoteEventListener
extends RemoteStub<RemoteEventListener>
implements ManagedRemoteEventListener {
    static final long serialVersionUID = 2L;

    public LRMIRemoteEventListener() {
    }

    public LRMIRemoteEventListener(RemoteEventListener directRefProxy, RemoteEventListener dynamicProxy) {
        super(directRefProxy, dynamicProxy);
    }

    @Override
    public void shutdown(GSEventRegistration registration) {
        RemoteEventListener proxy = (RemoteEventListener)this.getProxy();
        if (proxy instanceof ManagedRemoteEventListener) {
            ((ManagedRemoteEventListener)proxy).shutdown(registration);
        }
    }

    @OneWayRemoteCall
    public void notify(RemoteEvent event) throws RemoteException, UnknownEventException {
        ((RemoteEventListener)this.getProxy()).notify(event);
    }

    @Override
    public void init(GSEventRegistration registration) {
        RemoteEventListener listener = (RemoteEventListener)this.getProxy();
        if (listener instanceof ManagedRemoteEventListener) {
            ((ManagedRemoteEventListener)listener).init(registration);
        }
    }

    static {
        LRMIRemoteEventListener.init(new Callable(){

            public Object call() throws SecurityException, NoSuchMethodException {
                IMethod<T>[] methods;
                String oneWayNotifySysProp = System.getProperty("com.gs.onewaynotify", Boolean.TRUE.toString());
                boolean oneWayNotifyRequired = Boolean.parseBoolean(oneWayNotifySysProp);
                if (!oneWayNotifyRequired) {
                    return null;
                }
                for (IMethod<OneWayRemoteCall> iMethod : methods = ReflectionUtil.createMethods(LRMIRemoteEventListener.class.getDeclaredMethods())) {
                    OneWayRemoteCall oneWayAnnotation = iMethod.getAnnotation(OneWayRemoteCall.class);
                    if (oneWayAnnotation == null) continue;
                    IMethod iMethod2 = ReflectionUtil.createMethod(RemoteEventListener.class.getMethod(iMethod.getName(), iMethod.getParameterTypes()));
                    OneWayMethodRepository.register(iMethod2);
                }
                return null;
            }
        });
    }
}

